package org.codeberg.zenxarch.zombies.spawning;

import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_6880;
import org.codeberg.zenxarch.mob_variants_api.registry.MobRegistryKeys;
import org.codeberg.zenxarch.mob_variants_api.registry.MobVariantUtils;
import org.codeberg.zenxarch.mob_variants_api.variant.MobVariant;
import org.codeberg.zenxarch.zombies.Zombies;
import org.codeberg.zenxarch.zombies.entity.ExtendedZombieEntity;
import org.jetbrains.annotations.Nullable;

public final class ZombieNbtUtils {
  private ZombieNbtUtils() {
    throw new IllegalStateException("Utility class");
  }

  private static final String ZOMBIE_ID_KEY = "zenxarch_zombie_id";

  public static Optional<class_6880<MobVariant>> getVariantFromView(class_1937 world, class_11368 view) {
    var idKey = view.getOptionalString(ZOMBIE_ID_KEY);
    if (idKey.isEmpty()) return Optional.empty();
    return switch (idKey.get()) {
      case "" -> Optional.empty();
      case String id -> {
        try {
          yield MobVariantUtils.getOptionalVariant(world, MobVariantUtils.toId(id));
        } catch (Exception e) {
          Zombies.LOGGER.info("Exception caught: {}", e.getMessage());
          yield Optional.empty();
        }
      }
    };
  }

  public static void setVariantToView(
      class_1937 world, class_11372 view, @Nullable class_6880<MobVariant> variant) {
    var registry = world.method_30349().method_46759(MobRegistryKeys.MOB_VARIANT);
    if (registry.isEmpty()) return;
    if (variant == null) return;
    view.method_71469(ZombieNbtUtils.ZOMBIE_ID_KEY, variant.method_55840());
  }

  public static Optional<class_1297> loadFromView(class_11368 view, class_1937 world) {
    return getVariantFromView(world, view).map(variant -> loadFromView(world, variant, view));
  }

  private static ExtendedZombieEntity loadFromView(
      class_1937 world, class_6880<MobVariant> variant, class_11368 view) {
    var result = new ExtendedZombieEntity(world);
    result.method_5651(view);
    return result;
  }
}
