/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.mob_variants_api.client;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.client.rendering.v1.FabricRenderState;
import net.fabricmc.fabric.api.client.rendering.v1.RenderStateDataKey;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import org.codeberg.zenxarch.mob_variants_api.MobVariantsApiMod;
import org.jetbrains.annotations.Contract;

@Environment(value=EnvType.CLIENT)
public class ExtendedRenderStateDataKey<T> {
    private final RenderStateDataKey<T> key;
    private final Function<class_1309, T> provider;
    private final Predicate<T> condition;

    @Contract(value="_,null,_ -> fail")
    private ExtendedRenderStateDataKey(class_2960 id, Function<class_1309, T> provider, Predicate<T> condition) {
        if (provider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        this.key = RenderStateDataKey.create(() -> ((class_2960)id).toString());
        this.provider = provider;
        this.condition = condition;
    }

    public void set(class_1309 entity, FabricRenderState state) {
        if (this.provider == null) {
            return;
        }
        state.setData(this.key, this.provider.apply(entity));
    }

    public Optional<T> get(FabricRenderState state) {
        Object value = state.getData(this.key);
        if (value == null) {
            return Optional.empty();
        }
        if (this.condition != null && !this.condition.test(value)) {
            return Optional.empty();
        }
        return Optional.ofNullable(value);
    }

    public static <T> Builder<T> builder(String id) {
        return new Builder(id);
    }

    public static <T> Builder<T> builder(class_2960 id) {
        return new Builder(id);
    }

    public static <T> Builder<T> builder(AttachmentType<T> attachmentType) {
        return new Builder<T>(attachmentType);
    }

    public static <R, T> Builder<T> builder(AttachmentType<R> attachmentType, Function<R, T> converter) {
        return new Builder<T>(attachmentType, converter);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Builder<T> {
        private final class_2960 id;
        private Function<class_1309, T> provider;
        private Predicate<T> condition;

        public Builder(class_2960 id) {
            this.id = id;
        }

        public Builder(String id) {
            this.id = MobVariantsApiMod.id(id);
        }

        public Builder(AttachmentType<T> attachmentType) {
            this(attachmentType.identifier());
            this.attachment(attachmentType);
        }

        public <R> Builder(AttachmentType<R> attachmentType, Function<R, T> converter) {
            this(attachmentType.identifier());
            this.attachment(attachmentType, converter);
        }

        public Builder<T> provider(Function<class_1309, T> provider) {
            this.provider = provider;
            return this;
        }

        public Builder<T> attachment(AttachmentType<T> type) {
            this.provider = living -> living.getAttached(type);
            return this;
        }

        public <R> Builder<T> attachment(AttachmentType<R> type, Function<R, T> converter) {
            this.provider = living -> {
                Object value = living.getAttached(type);
                if (value == null) {
                    return null;
                }
                return converter.apply(value);
            };
            return this;
        }

        public Builder<T> condition(Predicate<T> condition) {
            this.condition = condition;
            return this;
        }

        public ExtendedRenderStateDataKey<T> build() {
            return new ExtendedRenderStateDataKey<T>(this.id, this.provider, this.condition);
        }
    }
}

