package org.codeberg.zenxarch.zombies.spawning;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import org.codeberg.zenxarch.zombies.ZombieGamerules;
import org.codeberg.zenxarch.zombies.math.IntRange;
import org.codeberg.zenxarch.zombies.spawning.provider.PosRangeProvider;
import org.codeberg.zenxarch.zombies.spawning.provider.SpawnPosProvider;

public final class SpawnProvider {
  private static final class_5819 random = class_5819.method_43047();
  private static final int SQ_NEARBY_RANGE = 16 * 16;

  private SpawnProvider() {
    throw new IllegalStateException("Utility class");
  }

  private static boolean isTooCloseToAny(class_2338 b, List<class_2338> positions) {
    for (var pos : positions) {
      var sqDist = pos.method_10262(b);
      if (sqDist < SQ_NEARBY_RANGE) return false;
    }
    return true;
  }

  private static Optional<class_2338> validate(
      class_3218 world, List<class_2338> positions, Optional<class_2338> pos) {
    return pos.filter(b -> isTooCloseToAny(b, positions))
        .filter(pz -> SpawnUtils.canSpawnAtPosBasic(world, pz));
  }

  private static boolean doesNotBlockMob(class_3218 world, class_2338 pos) {
    return world.method_8320(pos).method_26220(world, pos).method_1110();
  }

  private static boolean doesNotContainFluid(class_3218 world, class_2338 pos) {
    return world.method_8316(pos).method_15769();
  }

  private static Optional<class_2338> adjustPos(class_3218 world, class_2338 ipos, IntRange yRange) {
    var pos = ipos.method_25503();

    for (var y : yRange.iterate()) {
      pos.method_33098(y + 1);
      if (!doesNotBlockMob(world, pos)) return Optional.of(pos.method_10084());
      if (!doesNotContainFluid(world, pos)) return Optional.empty();
    }

    return Optional.empty();
  }

  private static IntRange getYRange(class_3218 world, class_2338 centerPos, class_2338 pos) {
    final var providers =
        List.of(
            PosRangeProvider.AROUND_CENTER,
            PosRangeProvider.HEIGHTMAP_BOUNDS,
            PosRangeProvider.ZERO_BLOCKLIGHT);
    var ranges = new ArrayList<IntRange>(providers.size());
    for (var provider : providers) ranges.add(provider.get(world, pos, centerPos));

    for (var range : ranges) if (!range.isValid()) return IntRange.INVALID;

    var result = ranges.get(0);
    for (int i = 1; i < ranges.size(); i++) {
      result = result.intersection(ranges.get(i));
      if (!result.isValid()) return IntRange.INVALID;
    }

    return result;
  }

  public static Optional<class_2338> giveSpawnPositions(
      class_3218 world,
      class_2338 centerPos,
      List<class_2338> positions,
      Object2IntMap<class_2382> densityMap,
      int toSpawn) {
    var spawnTries =
        (toSpawn * 100) / (world.method_64395().method_8356(ZombieGamerules.SPAWN_SPEED) * 20);
    spawnTries = Math.max(spawnTries, 1);

    var maxDensity = ZombieDensityMap.getMaxDensity(toSpawn);

    for (var pos : SpawnPosProvider.MIXED.iterate(world, random, centerPos, toSpawn)) {
      if (SpawnUtils.burnsZombie(world, pos) || ZombieDensityMap.get(densityMap, pos) > maxDensity)
        continue;

      var adjustedPos = tryAdjustRandomPos(world, centerPos, pos);
      adjustedPos = validate(world, positions, adjustedPos);
      if (adjustedPos.isPresent()) return adjustedPos;
    }
    return Optional.empty();
  }

  private static Optional<class_2338> tryAdjustRandomPos(
      class_3218 world, class_2338 origin, class_2338 pos) {
    var range = getYRange(world, origin, pos);
    if (!range.isValid()) return Optional.empty();

    return adjustPos(world, pos, range);
  }
}
