package org.codeberg.zenxarch.zombies.spawning.provider;

import com.google.common.collect.AbstractIterator;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

@FunctionalInterface
public interface SpawnPosProvider {
  static final int SPAWN_RANGE = 80;

  public void modify(class_2338.class_2339 pos, class_3218 world, class_5819 random, class_2338 center);

  public static SpawnPosProvider RANDOM =
      (pos, world, random, center) ->
          pos.method_10103(
              around(random, center.method_10263(), SPAWN_RANGE),
              around(random, center.method_10264(), SPAWN_RANGE),
              around(random, center.method_10260(), SPAWN_RANGE));

  public static SpawnPosProvider SURFACE =
      (pos, world, random, center) ->
          setToTopPosAt(
              world,
              around(random, center.method_10263(), SPAWN_RANGE),
              around(random, center.method_10260(), SPAWN_RANGE),
              pos);

  public static SpawnPosProvider MIXED =
      (pos, world, random, center) -> {
        var topY = world.method_67393(class_2902.class_2903.field_13203, center);
        var distToSurface = center.method_10264() + 8 - topY;
        ((distToSurface > 0 && random.method_43056()) ? SURFACE : RANDOM)
            .modify(pos, world, random, center);
      };

  public default Iterable<class_2338> iterate(
      class_3218 world, class_5819 random, class_2338 centerPos, int count) {
    return () ->
        new AbstractIterator<class_2338>() {
          final class_2338.class_2339 pos = new class_2338.class_2339();
          int remaining = count;

          @Override
          protected class_2338 computeNext() {
            if (remaining == 0) return this.endOfData();
            remaining--;
            modify(pos, world, random, centerPos);
            return pos.method_10062();
          }
        };
  }

  private static int around(class_5819 random, int center, int range) {
    return center + random.method_39332(-range, range);
  }

  private static void setToTopPosAt(class_3218 world, int x, int z, class_2338.class_2339 mutable) {
    mutable.method_10103(x, world.method_8624(class_2902.class_2903.field_13203, x, z), z);
  }
}
