package org.codeberg.zenxarch.mob_variants_api.variant.effect.pair;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_3218;
import net.minecraft.class_5699;
import net.minecraft.class_5862;
import net.minecraft.class_5863;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.MobEffect;
import org.jetbrains.annotations.Nullable;

public record RandomMobEffect(List<MobEffect> effects, class_5863 chance) implements MobEffect {

  public static final MapCodec<RandomMobEffect> CODEC =
      RecordCodecBuilder.mapCodec(
          instance ->
              instance
                  .group(
                      class_5699.method_65313(MobEffect.CODEC)
                          .fieldOf("effects")
                          .forGetter(RandomMobEffect::effects),
                      class_5863.field_29007
                          .optionalFieldOf("chance", class_5862.method_33908(1.0f))
                          .forGetter(RandomMobEffect::chance))
                  .apply(instance, RandomMobEffect::new));

  @Override
  public void run(class_3218 world, class_1308 mob, @Nullable class_1309 adversery) {
    var random = mob.method_59922();
    if (random.method_43058() >= chance.method_33920(random)) return;
    class_156.method_40083(effects, random).ifPresent(effect -> effect.run(world, mob, adversery));
  }

  @Override
  public MapCodec<RandomMobEffect> getCodec() {
    return CODEC;
  }

  public static MobEffect create(MobEffect... effects) {
    if (effects.length == 0) return DefaultMobEffect.create();
    if (effects.length == 1) return effects[0];
    return new RandomMobEffect(List.of(effects), class_5862.method_33908(1.0f));
  }

  public static MobEffect create(class_5863 chance, MobEffect... effects) {
    if (effects.length == 0) return DefaultMobEffect.create();
    return new RandomMobEffect(List.of(effects), chance);
  }
}
