package org.codeberg.zenxarch.zombies.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10042;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_922;
import org.codeberg.zenxarch.zombies.data.entity.MobAttachments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(EnvType.CLIENT)
@Mixin(class_922.class)
public abstract class LivingEntityRendererMixin {

  @Unique private class_2960 zenxarch$texture_override = null;

  @WrapOperation(
      method = "getRenderLayer",
      at =
          @At(
              value = "INVOKE",
              target =
                  "Lnet/minecraft/client/render/entity/LivingEntityRenderer;getTexture(Lnet/minecraft/client/render/entity/state/LivingEntityRenderState;)Lnet/minecraft/util/Identifier;"))
  private class_2960 zenxarch$modifyTexture(
      class_922<?, ?, ?> self,
      class_10042 renderState,
      Operation<class_2960> op) {
    if (this.zenxarch$texture_override != null
        && class_310.method_1551()
            .method_1478()
            .method_14486(zenxarch$texture_override)
            .isPresent()) return this.zenxarch$texture_override;
    return op.call(self, renderState);
  }

  @Inject(
      method =
          "updateRenderState(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/client/render/entity/state/LivingEntityRenderState;F)V",
      at = @At("HEAD"))
  private void zenxarch$tryGetTextureOverride(
      class_1309 livingEntity,
      class_10042 livingEntityRenderState,
      float f,
      CallbackInfo ci) {
    if (livingEntity.hasAttached(MobAttachments.TEXTURE_OVERRIDE)) {
      this.zenxarch$texture_override =
          livingEntity.getAttached(MobAttachments.TEXTURE_OVERRIDE).comp_3627();
    } else {
      this.zenxarch$texture_override = null;
    }
  }
}
