/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.zombies.spawning;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import org.codeberg.zenxarch.zombies.Zombies;
import org.codeberg.zenxarch.zombies.entity.ExtendedZombieEntity;
import org.codeberg.zenxarch.zombies.entity.variant.MobVariant;
import org.codeberg.zenxarch.zombies.registry.ZombieRegistryKeys;
import org.jetbrains.annotations.Nullable;

public final class ZombieNbtUtils {
    private static final String ZOMBIE_ID_KEY = "zenxarch_zombie_id";

    private ZombieNbtUtils() {
        throw new IllegalStateException("Utility class");
    }

    private static class_2960 toId(String id) {
        int i = id.indexOf(":");
        if (i >= 0) {
            String string = id.substring(i + 1);
            if (i != 0) {
                String string2 = id.substring(0, i);
                return class_2960.method_60655((String)string2, (String)string);
            }
            return Zombies.id(string);
        }
        return Zombies.id(id);
    }

    private static Optional<class_6880<MobVariant>> fromId(class_1937 world, class_2960 id) {
        return world.method_30349().method_30530(ZombieRegistryKeys.MOB_VARIANT).method_10223(id).map(Function.identity());
    }

    public static Optional<class_6880<MobVariant>> getVariantFromView(class_1937 world, class_11368 view) {
        Optional idKey = view.method_71441(ZOMBIE_ID_KEY);
        if (idKey.isEmpty()) {
            return Optional.empty();
        }
        String string = (String)idKey.get();
        Objects.requireNonNull(string);
        String string2 = string;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"", String.class}, (Object)string2, n)) {
            case 0 -> {
                Optional<class_6880<MobVariant>> var5_5;
                yield var5_5 = Optional.empty();
            }
            default -> {
                String id = string2;
                try {
                    Optional<class_6880<MobVariant>> var5_6 = ZombieNbtUtils.fromId(world, ZombieNbtUtils.toId(id));
                    yield var5_6;
                }
                catch (Exception e) {
                    Zombies.LOGGER.info("Exception caught: {}", (Object)e.getMessage());
                    Optional var5_7 = Optional.empty();
                    yield var5_7;
                }
            }
        };
    }

    public static void setVariantToView(class_1937 world, class_11372 view, @Nullable class_6880<MobVariant> variant) {
        Optional registry = world.method_30349().method_46759(ZombieRegistryKeys.MOB_VARIANT);
        if (registry.isEmpty()) {
            return;
        }
        if (variant == null) {
            return;
        }
        view.method_71469(ZOMBIE_ID_KEY, variant.method_55840());
    }

    public static Optional<class_1297> loadFromView(class_11368 view, class_1937 world) {
        return ZombieNbtUtils.getVariantFromView(world, view).map(variant -> ZombieNbtUtils.loadFromView(world, (class_6880<MobVariant>)variant, view));
    }

    private static ExtendedZombieEntity loadFromView(class_1937 world, class_6880<MobVariant> variant, class_11368 view) {
        ExtendedZombieEntity result = new ExtendedZombieEntity(world);
        result.method_5651(view);
        return result;
    }
}

