package org.codeberg.zenxarch.mob_variants_api.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.Optional;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import org.codeberg.zenxarch.mob_variants_api.variant.MobAttachments;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1308.class)
public abstract class MobEntityMixin implements AttachmentTarget {

  @ModifyReturnValue(method = "getLootTableKey", at = @At("RETURN"))
  private Optional<class_5321<class_52>> zenxarch$override_loot_table(
      Optional<class_5321<class_52>> lootTable) {
    if (this.hasAttached(MobAttachments.LOOT_TABLE))
      return Optional.of(this.getAttached(MobAttachments.LOOT_TABLE));
    return lootTable;
  }

  @Inject(method = "setTarget", at = @At("TAIL"))
  private void zenxarch$setTargetHook(@Nullable class_1309 target, CallbackInfo ci) {
    var self = (class_1308) (Object) this;
    if (!(self.method_73183() instanceof class_3218 world)) return;
    if (target == null) {
      if (self.hasAttached(MobAttachments.ON_REMOVE_TARGET))
        self.getAttached(MobAttachments.ON_REMOVE_TARGET).run(world, self, target);
    } else {
      if (self.hasAttached(MobAttachments.ON_ADD_TARGET))
        self.getAttached(MobAttachments.ON_ADD_TARGET).run(world, self, target);
    }
  }
}
