package org.codeberg.zenxarch.mob_variants_api.variant.effect.single;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_5699;
import net.minecraft.class_9734;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.LivingEffect;

public record SpawnParticleEffect(class_9734 effect, int count)
    implements LivingEffect {

  public static final MapCodec<SpawnParticleEffect> CODEC =
      Codec.mapPair(
              class_9734.field_51721,
              class_5699.field_33442.optionalFieldOf("count", 0))
          .xmap(
              pair -> new SpawnParticleEffect(pair.getFirst(), pair.getSecond()),
              effect -> new Pair<>(effect.effect, effect.count));

  public SpawnParticleEffect(class_9734 effect) {
    this(effect, 0);
  }

  @Override
  public void run(class_3218 world, class_1309 target) {
    var pos = target.method_73189();
    var random = target.method_59922();
    var move = target.method_60478();
    var width = target.method_17681();
    var height = target.method_17682();
    var boundingBoxCenter = pos.method_10214() + height / 2;
    world.method_65096(
        this.effect.comp_2751(),
        this.effect.comp_2752().method_60254(pos.method_10216(), pos.method_10216(), width, random),
        this.effect.comp_2753().method_60254(pos.method_10214(), boundingBoxCenter, height, random),
        this.effect.comp_2752().method_60254(pos.method_10215(), pos.method_10215(), width, random),
        this.count,
        this.effect.comp_2754().method_60262(move.method_10216(), random),
        this.effect.comp_2755().method_60262(move.method_10214(), random),
        this.effect.comp_2754().method_60262(move.method_10215(), random),
        this.effect.comp_2756().method_33920(random));
  }

  @Override
  public MapCodec<SpawnParticleEffect> getCodec() {
    return CODEC;
  }
}
