package org.codeberg.zenxarch.zombies;

import static org.codeberg.zenxarch.zombies.ZombieGamerules.*;

import com.mojang.serialization.Codec;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentSyncPredicate;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityCombatEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_9135;

public interface ZombieHealth {

  public static final AttachmentType<Integer> ZOMBIE_KILLS =
      AttachmentRegistry.create(
          Zombies.id("zombie_kills"),
          builder ->
              builder
                  .persistent(Codec.INT)
                  .initializer(() -> 0)
                  .syncWith(class_9135.field_49675, AttachmentSyncPredicate.targetOnly()));

  public static void registerEvents() {
    ServerEntityCombatEvents.AFTER_KILLED_OTHER_ENTITY.register(
        (world, self, dead, source) -> {
          if (self instanceof class_3222 player
              && dead.method_5864().method_20210(class_3483.field_46231)) {
            onKillZombie(player);
            updatePlayerStats(world, player);
          }
        });

    ServerPlayerEvents.JOIN.register(
        (player) -> updatePlayerStats(player.method_51469(), player));

    ServerPlayerEvents.AFTER_RESPAWN.register(
        (oldPlayer, newPlayer, alive) -> updatePlayerStats(newPlayer.method_51469(), newPlayer));
  }

  public static void updatePlayerStats(class_3218 world, class_3222 player) {
    var rules = world.method_64395();
    if (!rules.method_8355(DO_ZOMBIE_KILLS_BASED_HEARTS)) return;

    var newMaxHealth =
        getNewMaxHealth(
            player.getAttachedOrCreate(ZOMBIE_KILLS),
            rules.method_8356(ZOMBIE_KILLS_FOR_MAX_HEARTS),
            rules.method_8356(MIN_HEARTS),
            rules.method_8356(MAX_HEARTS));

    var newHealth = (player.method_6032() / player.method_6063()) * newMaxHealth;

    player.method_5996(class_5134.field_23716).method_6192(newMaxHealth);
    player.method_6033(newHealth);
  }

  private static float getNewMaxHealth(int kills, int maxKills, int minHearts, int maxHearts) {
    var delta = (float) kills / maxKills;
    return class_3532.method_15340(class_3532.method_48781(delta, minHearts, maxHearts), minHearts, maxHearts)
        * 2f;
  }

  private static void onKillZombie(class_3222 player) {
    var kills = player.getAttachedOrCreate(ZOMBIE_KILLS);
    player.setAttached(ZOMBIE_KILLS, kills + 1);
  }
}
