package org.codeberg.zenxarch.zombies.client;

import net.minecraft.class_10086;
import net.minecraft.class_1642;
import net.minecraft.class_3532;
import net.minecraft.class_3886;
import net.minecraft.class_4587;
import net.minecraft.class_5617.class_5618;
import net.minecraft.class_7833;
import org.codeberg.zenxarch.mob_variants_api.client.ExtendedRenderStateDataKey;
import org.codeberg.zenxarch.mob_variants_api.variant.MobAttachments;
import org.codeberg.zenxarch.mob_variants_api.variant.OverlayAttachment;

public class ExtendedZombieEntityRenderer extends class_3886 {

  public static ExtendedRenderStateDataKey<OverlayAttachment> OVERLAY =
      ExtendedRenderStateDataKey.builder(MobAttachments.OVERLAY).build();

  public ExtendedZombieEntityRenderer(class_5618 context) {
    super(context);
    this.method_4046(new ExtendedZombieEntityOverlayRenderer(this));
  }

  @Override
  public void method_62369(class_1642 zombie, class_10086 state, float f) {
    super.method_62369(zombie, state, f);
    OVERLAY.set(zombie, state);
  }

  @Override
  protected void setupTransforms(
      class_10086 state, class_4587 matrices, float bodyYaw, float baseHeight) {
    super.method_4058(state, matrices, bodyYaw, baseHeight);
    if (state.field_53403 > 0f) {
      var finalPitch = class_3532.method_16439(state.field_53403, 0f, -10f - state.field_53448);
      matrices.method_49278(
          class_7833.field_40714.rotationDegrees(finalPitch),
          0,
          (state.field_53330 / 2) / baseHeight,
          0);
    }
  }
}
