package org.codeberg.zenxarch.zombies.client.debughud;

import net.minecraft.class_11630;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import org.codeberg.zenxarch.zombies.spawning.SpawnerAttachments;
import org.codeberg.zenxarch.zombies.spawning.ZombieApocalypse;
import org.codeberg.zenxarch.zombies.spawning.ZombieDensityMap;
import org.jetbrains.annotations.Nullable;

public class ZombieCountDebugHudEntry implements ZombieDebugHudEntry {

  @Override
  public void method_72751(
      class_11630 lines,
      @Nullable class_1937 world,
      @Nullable class_2818 clientChunk,
      @Nullable class_2818 chunk) {

    if (world == null) return;
    if (!(world instanceof class_3218 serverWorld)) return;

    var player = class_310.method_1551().field_1724;
    if (player == null) return;
    var pos = player.method_24515();

    var zombies =
        SpawnerAttachments.getApocalypses(serverWorld).stream()
            .mapToInt(spawner -> getZombie(spawner, pos))
            .sum();
    addLine(lines, "Extended Zombies : " + zombies);
  }

  private int getZombie(ZombieApocalypse apocalypse, class_2338 center) {
    var zombieCount = apocalypse.getZombieCount();
    if (zombieCount == null) return -1;
    return ZombieDensityMap.getSubMap(zombieCount, center).values().intStream().sum();
  }
}
