package org.codeberg.zenxarch.zombies.loot_table.condition;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5342;

public record TimeCheckLootCondition(Optional<Boolean> isDay, Optional<Boolean> isNight)
    implements class_5341 {

  public static final MapCodec<TimeCheckLootCondition> CODEC =
      RecordCodecBuilder.mapCodec(
          instance ->
              instance
                  .group(
                      Codec.BOOL.optionalFieldOf("day").forGetter(TimeCheckLootCondition::isDay),
                      Codec.BOOL
                          .optionalFieldOf("night")
                          .forGetter(TimeCheckLootCondition::isNight))
                  .apply(instance, TimeCheckLootCondition::new));

  @Override
  public boolean test(class_47 context) {
    var world = context.method_299();
    return isDay.map(v -> v == world.method_8530()).orElse(true)
        && isNight.map(v -> v == world.method_23886()).orElse(true);
  }

  @Override
  public class_5342 method_29325() {
    return ZombieLootConditionTypes.TIME_CHECK;
  }

  public static Builder create() {
    return new Builder();
  }

  public static class Builder implements class_5341.class_210 {
    private Optional<Boolean> day = Optional.empty();
    private Optional<Boolean> night = Optional.empty();

    public Builder day(boolean day) {
      this.day = Optional.of(day);
      return this;
    }

    public Builder night(boolean night) {
      this.night = Optional.of(night);
      return this;
    }

    public TimeCheckLootCondition build() {
      return new TimeCheckLootCondition(this.day, this.night);
    }
  }
}
