package org.codeberg.zenxarch.zombies.mixin;

import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_3730;
import org.codeberg.zenxarch.zombies.spawning.ZombieNbtUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1299.class)
public abstract class EntityTypeMixin {
  @Inject(method = "getEntityFromData", at = @At("HEAD"), cancellable = true)
  private static void zenxarch$inject_getEntityFromNbt(
      class_11368 view,
      class_1937 world,
      class_3730 reason,
      CallbackInfoReturnable<Optional<class_1297>> cir) {
    var opt = ZombieNbtUtils.loadFromView(view, world);
    if (opt.isPresent()) cir.setReturnValue(opt);
  }
}
