package org.codeberg.zenxarch.zombies.spawning;

import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_6880;
import org.codeberg.zenxarch.mob_variants_api.registry.MobVariants;
import org.codeberg.zenxarch.mob_variants_api.variant.MobVariant;
import org.codeberg.zenxarch.zombies.entity.ExtendedZombieEntity;
import org.jetbrains.annotations.Nullable;

public final class ZombieNbtUtils {
  private ZombieNbtUtils() {
    throw new IllegalStateException("Utility class");
  }

  private static final String ZOMBIE_ID_KEY = "zenxarch_zombie_id";

  public static Optional<class_6880<MobVariant>> getVariantFromView(class_1937 world, class_11368 view) {
    return MobVariants.readVariant(view, ZOMBIE_ID_KEY);
  }

  public static void setVariantToView(
      class_1937 world, class_11372 view, @Nullable class_6880<MobVariant> variant) {
    MobVariants.putVariant(view, ZOMBIE_ID_KEY, variant);
  }

  public static Optional<class_1297> loadFromView(class_11368 view, class_1937 world) {
    return getVariantFromView(world, view).map(variant -> loadFromView(world, variant, view));
  }

  private static ExtendedZombieEntity loadFromView(
      class_1937 world, class_6880<MobVariant> variant, class_11368 view) {
    var result = new ExtendedZombieEntity(world);
    result.method_5651(view);
    return result;
  }
}
