/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.zombies.difficulty;

import java.util.function.ToDoubleFunction;
import java.util.stream.Stream;
import net.minecraft.class_1267;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4174;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import org.codeberg.zenxarch.zombies.difficulty.ItemAttributeUtils;
import org.codeberg.zenxarch.zombies.spawning.ZombieApocalypse;

public abstract class DifficultyCalculations {
    private static final int TICKS_PER_HOUR = 72000;
    private static final int TICKS_PER_DAY = 24000;

    private DifficultyCalculations() {
        throw new IllegalStateException("Utility class");
    }

    private static double normalize(double value) {
        return Math.clamp(value, 0.0, 1.0);
    }

    private static double[] getPlayerScore(class_3218 world, class_2338 pos) {
        int players = 0;
        double[] result = new double[]{0.0, 0.0};
        for (class_3222 player : ZombieApocalypse.players(world)) {
            if (player.method_5707(pos.method_46558()) > 16384.0) continue;
            ++players;
            result[0] = result[0] + DifficultyCalculations.getPlayerScore(player);
            result[1] = result[1] + (double)player.method_14248().method_15025(class_3468.field_15403.method_14956((Object)class_1299.field_6051));
        }
        if (players == 0) {
            return result;
        }
        result[0] = DifficultyCalculations.normalize(result[0] / (double)players);
        result[1] = DifficultyCalculations.normalize(result[1] / (double)(players * 2500));
        return result;
    }

    private static double baseDifficulty(class_3218 world, class_2338 pos) {
        double dayFactor = DifficultyCalculations.mapDays(world.method_8407(), DifficultyCalculations.getDays(world));
        double moonSize = world.method_30272();
        double timeFactor = DifficultyCalculations.normalize(dayFactor * (1.0 + moonSize));
        double[] playerScore = DifficultyCalculations.getPlayerScore(world, pos);
        return timeFactor * 0.1 + timeFactor * playerScore[0] * 0.5 + playerScore[0] * 0.3 + playerScore[1] * 0.1;
    }

    public static double calculateDifficulty(class_3218 world, class_2338 pos) {
        double inhabitedTimeFactor = DifficultyCalculations.mapHours(world.method_8407(), DifficultyCalculations.getHoursInhabited((class_1937)world, pos));
        return inhabitedTimeFactor * DifficultyCalculations.baseDifficulty(world, pos);
    }

    private static double normalize(double value, double start, double end) {
        return class_3532.method_32854((double)value, (double)start, (double)end, (double)0.0, (double)1.0);
    }

    private static double mapDays(class_1267 difficulty, double days) {
        return switch (difficulty) {
            default -> throw new MatchException(null, null);
            case class_1267.field_5801 -> 0.0;
            case class_1267.field_5805 -> DifficultyCalculations.normalize(days, 5.0, 250.0);
            case class_1267.field_5802 -> DifficultyCalculations.normalize(days, 2.0, 150.0);
            case class_1267.field_5807 -> DifficultyCalculations.normalize(days, 0.0, 100.0);
        };
    }

    private static double mapHours(class_1267 difficulty, double hours) {
        double delta = switch (difficulty) {
            default -> throw new MatchException(null, null);
            case class_1267.field_5801 -> 0.0;
            case class_1267.field_5805 -> DifficultyCalculations.normalize(hours, 8.0, 1.5);
            case class_1267.field_5802 -> DifficultyCalculations.normalize(hours, 20.0, 1.5);
            case class_1267.field_5807 -> DifficultyCalculations.normalize(hours, 35.0, 1.5);
        };
        return class_3532.method_16436((double)delta, (double)0.25, (double)1.0);
    }

    public static double getDays(class_3218 world) {
        return (double)world.method_8532() / 24000.0;
    }

    public static double getHoursInhabited(class_1937 world, class_2338 pos) {
        if (world.method_8393(class_4076.method_18675((int)pos.method_10263()), class_4076.method_18675((int)pos.method_10260()))) {
            return (double)world.method_8500(pos).method_12033() / 72000.0;
        }
        return 0.0;
    }

    private static Stream<class_1799> items(class_3222 player) {
        return player.method_31548().method_67533().stream();
    }

    private static double getPlayerScore(class_3222 player) {
        double weaponSpeedScore = DifficultyCalculations.scoreWeapon(player, DifficultyCalculations::getDamagePerSecond, class_1802.field_8091, class_1802.field_22022);
        double weaponDamageScore = DifficultyCalculations.scoreWeapon(player, DifficultyCalculations::getAttackDamage, class_1802.field_8406, class_1802.field_22025);
        double foodScore = DifficultyCalculations.items(player).mapToDouble(DifficultyCalculations::scoreFood).sum();
        foodScore = DifficultyCalculations.normalize(foodScore);
        double armor = player.method_45325(class_5134.field_23724) + player.method_45325(class_5134.field_23725) + player.method_45325(class_5134.field_23718);
        armor = DifficultyCalculations.normalize(armor, 0.0, 32.0);
        return (armor + weaponSpeedScore + weaponDamageScore) * 0.25 + foodScore * 0.25;
    }

    private static double getAttackDamage(class_1799 stack) {
        return ItemAttributeUtils.getAttributeValue((class_1299<? extends class_1309>)class_1299.field_6097, stack, (class_6880<class_1320>)class_5134.field_23721);
    }

    private static double getAttackSpeed(class_1799 stack) {
        return ItemAttributeUtils.getAttributeValue((class_1299<? extends class_1309>)class_1299.field_6097, stack, (class_6880<class_1320>)class_5134.field_23723);
    }

    private static double getDamagePerSecond(class_1799 stack) {
        return DifficultyCalculations.getAttackDamage(stack) * DifficultyCalculations.getAttackSpeed(stack);
    }

    private static double scoreFood(class_1799 stack) {
        double score = 0.0;
        if (stack.method_57353().method_57832(class_9334.field_50075)) {
            score = (double)((class_4174)stack.method_58694(class_9334.field_50075)).comp_2491() * (double)stack.method_7947();
        }
        return DifficultyCalculations.normalize(score, 0.0, 400.0);
    }

    private static boolean isAWeapon(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        if (stack.method_57353().method_57832(class_9334.field_49636)) {
            return true;
        }
        return stack.method_7942();
    }

    private static double scoreWeapon(class_3222 player, ToDoubleFunction<class_1799> scorer, class_1792 minItem, class_1792 maxItem) {
        double baseMin = scorer.applyAsDouble(minItem.method_7854());
        double baseMax = scorer.applyAsDouble(maxItem.method_7854());
        double bestScore = DifficultyCalculations.items(player).filter(DifficultyCalculations::isAWeapon).mapToDouble(scorer).max().orElse(0.0);
        return DifficultyCalculations.normalize(bestScore, baseMin, baseMax);
    }
}

