/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.zombies.entity;

import java.util.List;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1408;
import net.minecraft.class_1642;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9652;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import org.codeberg.zenxarch.mob_variants_api.registry.MobVariants;
import org.codeberg.zenxarch.mob_variants_api.variant.MobAttachments;
import org.codeberg.zenxarch.mob_variants_api.variant.MobVariant;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.MobEffect;
import org.codeberg.zenxarch.zombies.ZombieGamerules;
import org.codeberg.zenxarch.zombies.brain.ZombieBrain;
import org.codeberg.zenxarch.zombies.data.ZMobVariantTags;
import org.codeberg.zenxarch.zombies.difficulty.ExtendedDifficulty;
import org.codeberg.zenxarch.zombies.spawning.ZombieNbtUtils;
import org.jetbrains.annotations.Nullable;

public class ExtendedZombieEntity
extends class_1642
implements SmartBrainOwner<ExtendedZombieEntity> {
    private static ZombieBrain<ExtendedZombieEntity> BRAIN_PROVIDER = new ZombieBrain();
    private class_6880<MobVariant> variant;

    public ExtendedZombieEntity(class_1937 world) {
        super(world);
    }

    protected class_4095.class_5303<?> method_28306() {
        return BRAIN_PROVIDER.getBrainProfile((class_1642)this);
    }

    public List<ExtendedSensor<ExtendedZombieEntity>> getSensors() {
        return BRAIN_PROVIDER.getSensors();
    }

    public BrainActivityGroup<ExtendedZombieEntity> getCoreTasks() {
        return BRAIN_PROVIDER.getCoreTasks(ExtendedZombieEntity::method_7216);
    }

    public BrainActivityGroup<ExtendedZombieEntity> getIdleTasks() {
        return BRAIN_PROVIDER.getIdleTasks();
    }

    public BrainActivityGroup<? extends ExtendedZombieEntity> getFightTasks() {
        return BRAIN_PROVIDER.getFightTasks();
    }

    protected void method_5959() {
    }

    public void method_7201(boolean canBreakDoors) {
    }

    protected class_1408 method_5965(class_1937 world) {
        return BRAIN_PROVIDER.createNavigation((class_1642)this, world);
    }

    protected void method_5958(class_3218 world) {
        super.method_5958(world);
        this.tickBrain((class_1309)this);
    }

    public boolean method_7216() {
        class_1937 class_19372 = this.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 sw = (class_3218)class_19372;
            return sw.method_64395().method_8355(ZombieGamerules.ZOMBIES_BURN_IN_DAYLIGHT);
        }
        return false;
    }

    protected ExtendedDifficulty getExtentedDifficulty(class_5425 serverWorld) {
        return new ExtendedDifficulty(serverWorld.method_8410(), this.method_24515());
    }

    public void initialize(class_5425 world) {
        this.method_5943(world, world.method_8404(this.method_24515()), class_3730.field_16459, null);
    }

    private void executeEvent(AttachmentType<MobEffect> attachment, class_3218 world, @Nullable class_1309 adversary) {
        if (!this.hasAttached(attachment)) {
            return;
        }
        ((MobEffect)this.getAttached(attachment)).run(world, (class_1308)this, adversary);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, class_1315 entityData) {
        if (entityData instanceof ExtendedZombieData) {
            ExtendedZombieData extendedZombieData = (ExtendedZombieData)entityData;
            this.setVariant(extendedZombieData.getVariant());
        } else {
            MobVariants.select((class_3218)world.method_8410(), (class_2338)this.method_24515(), ZMobVariantTags.ZOMBIE_VARIANTS).ifPresent(this::setVariant);
        }
        class_1315 result = super.method_5943(world, difficulty, spawnReason, (class_1315)new class_1642.class_1644(false, false));
        this.executeEvent((AttachmentType<MobEffect>)MobAttachments.ON_SPAWN, world.method_8410(), null);
        return result;
    }

    protected void method_5964(class_5819 random, class_1266 unused) {
        if (this.hasAttached(MobAttachments.EQUIPMENT_TABLE)) {
            return;
        }
        super.method_5964(random, unused);
    }

    protected void method_5984(class_5425 world, class_5819 random, class_1266 unused) {
        if (this.hasAttached(MobAttachments.EQUIPMENT_TABLE)) {
            MobAttachments.initEquipment((class_1308)this, (class_3218)world.method_8410(), (class_9652)((class_9652)this.getAttached(MobAttachments.EQUIPMENT_TABLE)), (class_1266)this.getExtentedDifficulty(world));
        } else {
            super.method_5984(world, random, unused);
        }
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        class_1309 living;
        if (!super.method_64397(world, source, amount)) {
            return false;
        }
        class_1297 class_12972 = source.method_5529();
        this.executeEvent((AttachmentType<MobEffect>)MobAttachments.ON_DAMAGE, world, class_12972 instanceof class_1309 ? (living = (class_1309)class_12972) : null);
        return true;
    }

    public boolean method_6121(class_3218 world, class_1297 target) {
        boolean result = super.method_6121(world, target);
        if (result && target instanceof class_1309) {
            class_1309 living = (class_1309)target;
            this.executeEvent((AttachmentType<MobEffect>)MobAttachments.ON_ATTACK, world, living);
        }
        return result;
    }

    protected void method_23733(@Nullable class_1309 adversary) {
        class_1937 class_19372 = this.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            this.executeEvent((AttachmentType<MobEffect>)MobAttachments.ON_KILLED, world, adversary);
        }
        super.method_23733(adversary);
    }

    public boolean method_5874(class_3218 world, class_1309 other, class_1282 source) {
        boolean result = super.method_5874(world, other, source);
        this.executeEvent((AttachmentType<MobEffect>)MobAttachments.ON_KILL, world, other);
        return result;
    }

    public void method_6078(class_1282 damageSource) {
        class_1937 class_19372;
        if (!this.method_31481() && !this.field_6272 && (class_19372 = this.method_73183()) instanceof class_3218) {
            class_1309 adversery;
            class_3218 world = (class_3218)class_19372;
            class_1297 class_12972 = damageSource.method_5529();
            this.executeEvent((AttachmentType<MobEffect>)MobAttachments.ON_DEATH, world, class_12972 instanceof class_1309 ? (adversery = (class_1309)class_12972) : null);
        }
        super.method_6078(damageSource);
    }

    public void method_5773() {
        class_1937 class_19372 = this.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            this.executeEvent((AttachmentType<MobEffect>)MobAttachments.ON_TICK, world, null);
        }
        super.method_5773();
    }

    protected void method_6001() {
        this.method_5996(class_5134.field_23727).method_6192(0.0);
    }

    protected void method_7205(float chanceMultiplier) {
        super.method_7205(chanceMultiplier);
        this.method_5996(class_5134.field_23727).method_6200(class_2960.method_60656((String)"leader_zombie_bonus"));
    }

    public void method_5749(class_11368 view) {
        super.method_5749(view);
        ZombieNbtUtils.getVariantFromView(this.method_73183(), view).ifPresent(this::setVariant);
    }

    public void method_5652(class_11372 view) {
        super.method_5652(view);
        ZombieNbtUtils.setVariantToView(this.method_73183(), view, this.getVariant());
    }

    public boolean method_5957(class_4538 world) {
        return world.method_8606((class_1297)this) && world.method_17892((class_1297)this) && (this.method_64462() || !world.method_22345(this.method_5829()));
    }

    public void setVariant(class_6880<MobVariant> variant) {
        this.variant = variant;
        MobVariants.updateAttachments((AttachmentTarget)this, variant);
    }

    public class_6880<MobVariant> getVariant() {
        return this.variant;
    }

    public static class ExtendedZombieData
    extends class_1642.class_1644 {
        private final class_6880<MobVariant> variant;

        public ExtendedZombieData(class_6880<MobVariant> variant, boolean baby, boolean tryChickenJockey) {
            super(baby, tryChickenJockey);
            this.variant = variant;
        }

        public class_6880<MobVariant> getVariant() {
            return this.variant;
        }
    }
}

