package org.codeberg.zenxarch.zombies.data.entity;

import static org.codeberg.zenxarch.zombies.Zombies.id;

import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentSyncPredicate;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_10726;
import net.minecraft.class_1266;
import net.minecraft.class_1308;
import net.minecraft.class_173;
import net.minecraft.class_181;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8567;
import net.minecraft.class_9652;
import org.codeberg.zenxarch.zombies.data.entity.effect.MobEffect;

public final class MobAttachments {
  private MobAttachments() {
    throw new IllegalStateException("Utility class");
  }

  public static final AttachmentType<class_10726> TEXTURE_OVERRIDE =
      AttachmentRegistry.create(
          id("texture_override"),
          builder ->
              builder
                  .persistent(class_10726.field_56393)
                  .syncWith(class_10726.field_56395, AttachmentSyncPredicate.all()));

  public static final AttachmentType<class_9652> EQUIPMENT_TABLE =
      AttachmentRegistry.createPersistent(id("equipment_table"), class_9652.field_51375);

  public static final AttachmentType<class_5321<class_52>> LOOT_TABLE =
      AttachmentRegistry.createPersistent(
          id("loot_table"), class_5321.method_39154(class_7924.field_50079));

  public static final AttachmentType<class_6885<class_8110>> INVULNERABLE_TO =
      AttachmentRegistry.createPersistent(
          id("invulnerable_to"), class_6895.method_40340(class_7924.field_42534));

  public static final AttachmentType<OverlayAttachment> OVERLAY =
      AttachmentRegistry.create(
          id("overlay"),
          builder ->
              builder
                  .persistent(OverlayAttachment.CODEC)
                  .syncWith(OverlayAttachment.PACKET_CODEC, AttachmentSyncPredicate.all()));

  public static final AttachmentType<MobEffect> ON_SPAWN = createZombieEvent("on_spawn");
  public static final AttachmentType<MobEffect> ON_TICK = createZombieEvent("on_tick");
  public static final AttachmentType<MobEffect> ON_ATTACK = createZombieEvent("on_attack");
  public static final AttachmentType<MobEffect> ON_DAMAGE = createZombieEvent("on_damage");
  public static final AttachmentType<MobEffect> ON_DEATH = createZombieEvent("on_death");
  public static final AttachmentType<MobEffect> ON_KILL = createZombieEvent("on_kill");
  public static final AttachmentType<MobEffect> ON_KILLED = createZombieEvent("on_killed");

  private static AttachmentType<MobEffect> createZombieEvent(String id) {
    return AttachmentRegistry.createPersistent(id(id), MobEffect.CODEC);
  }

  public static void initEquipment(
      class_1308 mob, class_3218 world, class_9652 table, class_1266 difficulty) {
    mob.method_59663(
        table.comp_2621(),
        new class_8567.class_8568(world)
            .method_51874(class_181.field_24424, mob.method_73189())
            .method_51874(class_181.field_1226, mob)
            .method_51871(difficulty.method_5458())
            .method_51875(class_173.field_50217),
        table.comp_2622());
  }

  public static void initialize() {
    // Force load class
  }
}
