package org.codeberg.zenxarch.zombies.spawning;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import org.codeberg.zenxarch.zombies.Zombies;
import org.codeberg.zenxarch.zombies.entity.ExtendedZombieEntity;
import org.codeberg.zenxarch.zombies.entity.variant.MobVariant;
import org.codeberg.zenxarch.zombies.registry.ZombieRegistryKeys;
import org.jetbrains.annotations.Nullable;

public final class ZombieNbtUtils {
  private ZombieNbtUtils() {
    throw new IllegalStateException("Utility class");
  }

  private static final String ZOMBIE_ID_KEY = "zenxarch_zombie_id";

  private static class_2960 toId(String id) {
    int i = id.indexOf(":");
    if (i >= 0) {
      String string = id.substring(i + 1);
      if (i != 0) {
        String string2 = id.substring(0, i);
        return class_2960.method_60655(string2, string);
      }
      return Zombies.id(string);
    }
    return Zombies.id(id);
  }

  private static Optional<class_6880<MobVariant>> fromId(class_1937 world, class_2960 id) {
    return world
        .method_30349()
        .method_30530(ZombieRegistryKeys.MOB_VARIANT)
        .method_10223(id)
        .map(Function.identity());
  }

  public static Optional<class_6880<MobVariant>> getVariantFromView(class_1937 world, class_11368 view) {
    var idKey = view.getOptionalString(ZOMBIE_ID_KEY);
    if (idKey.isEmpty()) return Optional.empty();
    return switch (idKey.get()) {
      case "" -> Optional.empty();
      case String id -> {
        try {
          yield fromId(world, toId(id));
        } catch (Exception e) {
          Zombies.LOGGER.info("Exception caught: {}", e.getMessage());
          yield Optional.empty();
        }
      }
    };
  }

  public static void setVariantToView(
      class_1937 world, class_11372 view, @Nullable class_6880<MobVariant> variant) {
    var registry = world.method_30349().method_46759(ZombieRegistryKeys.MOB_VARIANT);
    if (registry.isEmpty()) return;
    if (variant == null) return;
    view.method_71469(ZombieNbtUtils.ZOMBIE_ID_KEY, variant.method_55840());
  }

  public static Optional<class_1297> loadFromView(class_11368 view, class_1937 world) {
    return getVariantFromView(world, view).map(variant -> loadFromView(world, variant, view));
  }

  private static ExtendedZombieEntity loadFromView(
      class_1937 world, class_6880<MobVariant> variant, class_11368 view) {
    var result = new ExtendedZombieEntity(world);
    result.method_5651(view);
    return result;
  }
}
