package org.codeberg.zenxarch.mob_variants_api.variant.effect;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import org.codeberg.zenxarch.mob_variants_api.MobVariantsApiMod;
import org.codeberg.zenxarch.mob_variants_api.registry.MobRegisteries;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.single.*;

public interface LivingEffect {
  public static final Codec<LivingEffect> CODEC =
      MobRegisteries.LIVING_EFFECT.method_39673().dispatch(LivingEffect::getCodec, Function.identity());

  public void run(class_3218 world, class_1309 target);

  public MapCodec<? extends LivingEffect> getCodec();

  public static void init() {
    register("default", DefaultLivingEffect.CODEC);
    register("freeze", FreezeEffect.CODEC);
    register("ignite", IgniteEffect.CODEC);
    register("spawn_effect_cloud", SpawnEffectCloudEffect.CODEC);
    register("spawn_particle", SpawnParticleEffect.CODEC);
    register("apply_status_effect", StatusLivingEffect.CODEC);
    register("default_attribute", DefaultAttributeEffect.CODEC);
    register("attribute_modifier", AttributeModifierEffect.CODEC);
    register("explosion", ExplosionEffect.CODEC);
    register("bonemeal", BonemealLivingEffect.CODEC);
    register("remove_modifier", RemoveAttributeModifierEffect.CODEC);
    register("summon_vehicle", SummonVehicleEffect.CODEC);
  }

  private static void register(String id, MapCodec<? extends LivingEffect> codec) {
    class_2378.method_10230(MobRegisteries.LIVING_EFFECT, MobVariantsApiMod.id(id), codec);
  }
}
