package org.codeberg.zenxarch.mob_variants_api.variant.effect.single;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1428;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.LivingEffect;

public record SummonVehicleEffect(class_1299<?> entityType) implements LivingEffect {
  public static final MapCodec<SummonVehicleEffect> CODEC =
      class_1299.field_57582
          .xmap(SummonVehicleEffect::new, SummonVehicleEffect::entityType)
          .fieldOf("entityType");

  @Override
  public void run(class_3218 world, class_1309 target) {
    var beforePos = target.method_73189();
    var beforeYaw = target.method_36454();
    var beforePitch = target.method_36455();
    var entity =
        entityType.method_5888(world, null, target.method_24515(), class_3730.field_16460, false, false);
    if (entity == null) return;
    if (!(entity instanceof class_1309 living)) return;
    target.method_5804(living);
    if (!doesMobFit(world, target) || !doesMobFit(world, living)) {
      target.method_5848();
      target.method_60949(beforePos, beforeYaw, beforePitch);
      return;
    }

    world.method_8649(living);
    if (living instanceof class_1428 chicken) chicken.method_6473(true);
  }

  private boolean doesMobFit(class_3218 world, class_1309 entity) {
    return world.method_18026(entity.method_5829())
        && !world.method_22345(entity.method_5829())
        && world.method_8606(entity);
  }

  @Override
  public MapCodec<? extends LivingEffect> getCodec() {
    return CODEC;
  }
}
