/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.mob_variants_api.registry;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_10695;
import net.minecraft.class_10701;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.codeberg.zenxarch.mob_variants_api.registry.MobRegistryKeys;
import org.codeberg.zenxarch.mob_variants_api.variant.MobVariant;
import org.jetbrains.annotations.Nullable;

public final class MobVariants {
    private static final Set<class_6880<MobVariant>> entriesTemp = new ObjectOpenHashSet();

    private MobVariants() {
        throw new IllegalStateException("Utility class");
    }

    public static Optional<class_6880<MobVariant>> select(class_3218 world, class_2338 pos, class_6862<MobVariant> tag) {
        return world.method_30349().method_30530(MobRegistryKeys.MOB_VARIANT).method_46733(tag).flatMap(entryList -> class_10695.method_67162((Stream)entryList.method_40239(), class_6880::comp_349, (class_5819)world.method_8409(), (Object)class_10701.method_67169((class_5425)world, (class_2338)pos)));
    }

    public static void putVariant(class_11372 view, String key, @Nullable class_6880<MobVariant> variantEntry) {
        view.method_71477(key, MobVariant.ENTRY_CODEC, variantEntry);
    }

    public static Optional<class_6880<MobVariant>> readVariant(class_11368 view, String key) {
        return view.method_71426(key, MobVariant.ENTRY_CODEC);
    }

    public static void updateAttachments(AttachmentTarget target, class_6880<MobVariant> variant) {
        if (variant == null) {
            return;
        }
        MobVariants.updateAttachmentsImpl(target, variant);
        entriesTemp.clear();
    }

    private static void updateAttachmentsImpl(AttachmentTarget target, class_6880<MobVariant> variant) {
        if (!entriesTemp.add(variant)) {
            return;
        }
        ((MobVariant)variant.comp_349()).components().forEach((attachment, value) -> MobVariants.updateAttachment(target, attachment, value));
        ((MobVariant)variant.comp_349()).template().forEach(template -> MobVariants.updateAttachmentsImpl(target, (class_6880<MobVariant>)template));
    }

    private static <T> void updateAttachment(AttachmentTarget target, AttachmentType<?> attachment, Object value) {
        if (!target.hasAttached(attachment)) {
            target.setAttached(attachment, value);
        }
    }
}

