package org.codeberg.zenxarch.zombies;

import net.fabricmc.fabric.api.gamerule.v1.CustomGameRuleCategory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1928;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_8828;
import net.minecraft.server.MinecraftServer;

public final class ZombieGamerules {

  private ZombieGamerules() {
    throw new IllegalStateException("Utility class");
  }

  public static final CustomGameRuleCategory ZOMBIES_GENERAL =
      new CustomGameRuleCategory(
          Zombies.id("zombies_general"),
          class_5250.method_43477(class_8828.method_54232("Zombies"))
              .method_10862(class_2583.field_24360.method_10977(class_124.field_1054)));

  public static final CustomGameRuleCategory ZOMBIES_HEARTS =
      new CustomGameRuleCategory(
          Zombies.id("zombies_hearts"),
          class_5250.method_43477(class_8828.method_54232("Zombies Heart Mechanic"))
              .method_10862(class_2583.field_24360.method_10977(class_124.field_1054)));

  private static class_1928.class_4313<class_1928.class_4312> newGameRule(String name, int defaultValue) {
    return GameRuleRegistry.register(
        name, ZOMBIES_GENERAL, GameRuleFactory.createIntRule(defaultValue));
  }

  private static class_1928.class_4313<class_1928.class_4310> newGameRule(
      String name, boolean defaultValue) {
    return GameRuleRegistry.register(
        name, ZOMBIES_GENERAL, GameRuleFactory.createBooleanRule(defaultValue));
  }

  public static final class_1928.class_4313<class_1928.class_4312> MAX_ZOMBIES = newGameRule("maxZombies", 150);

  public static final class_1928.class_4313<class_1928.class_4312> SPAWN_SPEED =
      newGameRule("fillZombieCapOverSeconds", 30);

  public static final class_1928.class_4313<class_1928.class_4310> ZOMBIES_BURN_IN_DAYLIGHT =
      newGameRule("zombiesBurnInDaylight", false);

  public static final class_1928.class_4313<class_1928.class_4310> DO_ZOMBIE_SPAWNING =
      newGameRule("doZombieSpawning", true);

  public static final class_1928.class_4313<class_1928.class_4310> ZOMBIE_TARGET_PLAYER_ON_SPAWN =
      newGameRule("zombieTargetPlayerOnSpawn", false);

  // Heart mechanics
  public static final class_1928.class_4313<class_1928.class_4310> DO_ZOMBIE_KILLS_BASED_HEARTS =
      GameRuleRegistry.register(
          "doZombieKillsBasedHearts",
          ZOMBIES_HEARTS,
          GameRuleFactory.createBooleanRule(false, (server, rule) -> updateAllPlayers(server)));

  public static final class_1928.class_4313<class_1928.class_4312> ZOMBIE_KILLS_FOR_MAX_HEARTS =
      GameRuleRegistry.register(
          "zombieKillsForMaxHearts",
          ZOMBIES_HEARTS,
          GameRuleFactory.createIntRule(2500, 1, (server, rule) -> updateAllPlayers(server)));

  public static final class_1928.class_4313<class_1928.class_4312> MIN_HEARTS =
      GameRuleRegistry.register(
          "zombies.minHearts",
          ZOMBIES_HEARTS,
          GameRuleFactory.createIntRule(3, 1, (server, rule) -> updateAllPlayers(server)));

  public static final class_1928.class_4313<class_1928.class_4312> MAX_HEARTS =
      GameRuleRegistry.register(
          "zombies.maxHearts",
          ZOMBIES_HEARTS,
          GameRuleFactory.createIntRule(25, 1, (server, rules) -> updateAllPlayers(server)));

  private static void updateAllPlayers(MinecraftServer server) {
    for (var world : server.method_3738())
      for (var player : world.method_18456()) ZombieHealth.updatePlayerStats(world, player);
  }

  public static void initialize() {
    /* force load class */
  }
}
