package org.codeberg.zenxarch.zombies.difficulty;

import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import org.codeberg.zenxarch.zombies.ZombieGamerules;
import org.jetbrains.annotations.Unmodifiable;

@Unmodifiable
public class ExtendedDifficulty extends class_1266 {

  private final double difficulty;
  private final int maxZombies;

  public ExtendedDifficulty(class_3218 world, double difficulty, int maxZombies) {
    super(world.method_8407(), 0, 0, 0);
    this.difficulty = difficulty;
    this.maxZombies = maxZombies;
  }

  public ExtendedDifficulty(class_3218 world, class_2338 pos) {
    super(world.method_8407(), 0, 0, 0);
    this.difficulty = DifficultyCategory.calculateDifficulty(world, world.method_22350(pos));
    final var maxPossibleZombies = world.method_64395().method_8356(ZombieGamerules.MAX_ZOMBIES);
    this.maxZombies =
        this.difficulty >= 1.0 ? maxPossibleZombies : (int) (this.difficulty * maxPossibleZombies);
  }

  @Override
  public float method_5457() {
    return (float) (this.difficulty * 6.75);
  }

  @Override
  public boolean method_35020() {
    return method_5457() >= class_1267.field_5807.ordinal();
  }

  @Override
  public boolean method_5455(float difficulty) {
    return method_5457() > difficulty;
  }

  @Override
  public float method_5458() {
    return (float) this.difficulty;
  }

  public int getMaxZombies() {
    return this.maxZombies;
  }
}
