package org.codeberg.zenxarch.zombies.difficulty.category;

import net.minecraft.class_1267;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.codeberg.zenxarch.zombies.Zombies;
import org.codeberg.zenxarch.zombies.difficulty.DifficultyCategory;
import org.codeberg.zenxarch.zombies.difficulty.entry.DifficultyEntry;

public abstract class TimeCategory {
  private static final int TICKS_PER_HOUR = 60 * 60 * 20;
  private static final int TICKS_PER_DAY = 20 * 60 * 20;

  public static final DifficultyEntry DAYS_ENTRY =
      new DifficultyEntry() {
        @Override
        public int getWeight() {
          return 1;
        }

        @Override
        public double calculate(class_3218 world, class_2791 chunk) {
          var dayFactor = mapDays(world.method_8407(), getDays(world));
          var moonSize = (double) world.method_30272();
          return dayFactor * (1.0 + moonSize);
        }
      };

  public static final DifficultyEntry HOURS_ENTRY =
      new DifficultyEntry() {
        @Override
        public int getWeight() {
          return 10;
        }

        @Override
        public double calculate(class_3218 world, class_2791 chunk) {
          return mapHours(world.method_8407(), getHoursInhabited(world, chunk));
        }
      };

  public static final class_2960 DAYS_CATEGORY = Zombies.id("days");
  public static final class_2960 TIME_CATEGORY = Zombies.id("time");

  public static void initialize() {
    DifficultyCategory.addDifficultyEntry(DAYS_CATEGORY, DAYS_ENTRY);
    DifficultyCategory.addDifficultyEntry(TIME_CATEGORY, HOURS_ENTRY);
  }

  private static double normalize(double value, double start, double end) {
    return class_3532.method_32854(value, start, end, 0.0, 1.0);
  }

  private static double mapDays(class_1267 difficulty, double days) {
    return switch (difficulty) {
      case field_5801 -> 0.0;
      case field_5805 -> normalize(days, 5.0, 250.0);
      case field_5802 -> normalize(days, 2.0, 150.0);
      case field_5807 -> normalize(days, 0.0, 100.0);
    };
  }

  private static double mapHours(class_1267 difficulty, double hours) {
    var delta =
        switch (difficulty) {
          case field_5801 -> 0.0;
          case field_5805 -> normalize(hours, 8.0, 1.5);
          case field_5802 -> normalize(hours, 20.0, 1.5);
          case field_5807 -> normalize(hours, 35.0, 1.5);
        };
    return class_3532.method_16436(delta, 0.25, 1.0);
  }

  public static double getDays(class_3218 world) {
    return (double) world.method_8532() / TICKS_PER_DAY;
  }

  public static double getHoursInhabited(class_3218 world, class_2791 chunk) {
    return chunk.method_12033() / TICKS_PER_HOUR;
  }
}
