package org.codeberg.zenxarch.zombies.entity;

import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.codeberg.zenxarch.mob_variants_api.registry.MobVariants;
import org.codeberg.zenxarch.mob_variants_api.variant.MobAttachments;
import org.codeberg.zenxarch.mob_variants_api.variant.MobVariant;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.MobEffect;
import org.codeberg.zenxarch.zombies.ZombieGamerules;
import org.codeberg.zenxarch.zombies.brain.SmartZombieEntity;
import org.codeberg.zenxarch.zombies.data.ZMobVariantTags;
import org.codeberg.zenxarch.zombies.difficulty.ExtendedDifficulty;
import org.codeberg.zenxarch.zombies.spawning.ZombieNbtUtils;
import org.jetbrains.annotations.Nullable;

public class ExtendedZombieEntity extends SmartZombieEntity {

  private class_6880<MobVariant> variant;

  public ExtendedZombieEntity(class_1937 world) {
    super(world);
  }

  public boolean method_7216() {
    if (this.method_73183() instanceof class_3218 sw)
      return sw.method_64395().method_8355(ZombieGamerules.ZOMBIES_BURN_IN_DAYLIGHT);
    return false;
  }

  protected ExtendedDifficulty getExtentedDifficulty(class_5425 serverWorld) {
    return new ExtendedDifficulty(serverWorld.method_8410(), this.method_24515());
  }

  public void initialize(class_5425 world) {
    this.method_5943(world, world.method_8404(this.method_24515()), class_3730.field_16459, null);
  }

  private void executeEvent(
      AttachmentType<MobEffect> attachment, class_3218 world, @Nullable class_1309 adversary) {
    if (!this.hasAttached(attachment)) return;
    this.getAttached(attachment).run(world, this, adversary);
  }

  @Override
  public class_1315 method_5943(
      class_5425 world,
      class_1266 difficulty,
      class_3730 spawnReason,
      class_1315 entityData) {
    if (entityData instanceof ExtendedZombieData extendedZombieData) {
      this.setVariant(extendedZombieData.getVariant());
    } else {
      MobVariants.select(world.method_8410(), this.method_24515(), ZMobVariantTags.ZOMBIE_VARIANTS)
          .ifPresent(this::setVariant);
    }
    var result = super.method_5943(world, difficulty, spawnReason, new class_1644(false, false));
    executeEvent(MobAttachments.ON_SPAWN, world.method_8410(), null);
    return result;
  }

  @Override
  protected void method_5964(class_5819 random, class_1266 unused) {
    /* equipment is initialized in updateEnchantments */
    if (this.hasAttached(MobAttachments.EQUIPMENT_TABLE)) return;
    super.method_5964(random, unused);
  }

  @Override
  protected void method_5984(
      class_5425 world, class_5819 random, class_1266 unused) {
    if (this.hasAttached(MobAttachments.EQUIPMENT_TABLE))
      MobAttachments.initEquipment(
          this,
          world.method_8410(),
          this.getAttached(MobAttachments.EQUIPMENT_TABLE),
          getExtentedDifficulty(world));
    else super.method_5984(world, random, unused);
  }

  @Override
  public boolean method_64397(class_3218 world, class_1282 source, float amount) {
    if (!super.method_64397(world, source, amount)) return false;
    executeEvent(
        MobAttachments.ON_DAMAGE,
        world,
        source.method_5529() instanceof class_1309 living ? living : null);
    return true;
  }

  @Override
  public boolean method_6121(class_3218 world, class_1297 target) {
    var result = super.method_6121(world, target);
    if (result && target instanceof class_1309 living) {
      executeEvent(MobAttachments.ON_ATTACK, world, living);
    }
    return result;
  }

  @Override
  protected void method_23733(@Nullable class_1309 adversary) {
    if (this.method_73183() instanceof class_3218 world)
      executeEvent(MobAttachments.ON_KILLED, world, adversary);
    super.method_23733(adversary);
  }

  @Override
  public boolean method_5874(class_3218 world, class_1309 other, class_1282 source) {
    var result = super.method_5874(world, other, source);
    executeEvent(MobAttachments.ON_KILL, world, other);
    return result;
  }

  @Override
  public void method_6078(class_1282 damageSource) {
    if (!this.method_31481() && !this.field_6272 && this.method_73183() instanceof class_3218 world) {
      executeEvent(
          MobAttachments.ON_DEATH,
          world,
          damageSource.method_5529() instanceof class_1309 adversery ? adversery : null);
    }
    super.method_6078(damageSource);
  }

  @Override
  public void method_5773() {
    if (this.method_73183() instanceof class_3218 world)
      executeEvent(MobAttachments.ON_TICK, world, null);
    super.method_5773();
  }

  @Override
  protected void method_6001() {
    this.method_5996(class_5134.field_23727).method_6192(0.0);
  }

  @Override
  protected void method_7205(float chanceMultiplier) {
    super.method_7205(chanceMultiplier);
    this.method_5996(class_5134.field_23727)
        .method_6200(class_2960.method_60656("leader_zombie_bonus"));
  }

  @Override
  public void method_5749(class_11368 view) {
    super.method_5749(view);
    ZombieNbtUtils.getVariantFromView(this.method_73183(), view).ifPresent(this::setVariant);
  }

  @Override
  public void method_5652(class_11372 view) {
    super.method_5652(view);
    ZombieNbtUtils.setVariantToView(this.method_73183(), view, getVariant());
  }

  @Override
  public boolean method_5957(class_4538 world) {
    return world.method_8606(this)
        && world.method_17892(this)
        && (this.method_64462() || !world.method_22345(this.method_5829()));
  }

  public void setVariant(class_6880<MobVariant> variant) {
    this.variant = variant;
    MobVariants.updateAttachments(this, variant);
  }

  public class_6880<MobVariant> getVariant() {
    return this.variant;
  }

  public static class ExtendedZombieData extends class_1644 {

    private final class_6880<MobVariant> variant;

    public ExtendedZombieData(
        class_6880<MobVariant> variant, boolean baby, boolean tryChickenJockey) {
      super(baby, tryChickenJockey);
      this.variant = variant;
    }

    public class_6880<MobVariant> getVariant() {
      return this.variant;
    }
  }
}
