package org.codeberg.zenxarch.zombies.spawning;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1267;
import net.minecraft.class_1301;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.codeberg.zenxarch.zombies.ZombieGamerules;
import org.codeberg.zenxarch.zombies.difficulty.ExtendedDifficulty;
import org.codeberg.zenxarch.zombies.entity.ExtendedZombieEntity;

public class ZombieApocalypse {
  private class_3218 world;
  private Object2IntMap<class_2382> zombieCount;

  public ZombieApocalypse(class_3218 world) {
    this.world = world;
  }

  public Object2IntMap<class_2382> getZombieCount() {
    return this.zombieCount;
  }

  private void spawnZombie(ExtendedZombieEntity zombie) {
    if (world.method_64395().method_8355(ZombieGamerules.ZOMBIE_TARGET_PLAYER_ON_SPAWN)) {
      zombie.method_5980(
          world.method_8604(
              zombie.method_23317(),
              zombie.method_23318(),
              zombie.method_23321(),
              64.0,
              class_1301.field_6157.and(
                  class_1301.field_6156)));
    }
    zombie.initialize(this.world);
    this.world.method_30771(zombie);
  }

  private Optional<ExtendedZombieEntity> createZombie(class_2338 pos) {
    var zombie = new ExtendedZombieEntity(world);
    zombie.method_5725(pos, world.field_9229.method_43057() * 360.0F, 0.0F);
    if (zombie.method_5957(world)) return Optional.of(zombie);
    return Optional.empty();
  }

  private void spawnZombie(class_3222 player, class_2338 pos, ExtendedDifficulty difficulty) {
    createZombie(pos).ifPresent(this::spawnZombie);
  }

  public void spawnZombiesNear(class_3222 player, List<class_2338> positions) {
    var difficulty = new ExtendedDifficulty(this.world, player.method_24515());
    var toSpawn = difficulty.getMaxZombies();

    var subMap = ZombieDensityMap.getSubMap(zombieCount, player.method_24515());
    var total = subMap.values().intStream().sum();
    if (toSpawn <= total) return;

    SpawnProvider.giveSpawnPositions(world, player.method_24515(), positions, subMap, toSpawn)
        .ifPresent(pos -> this.spawnZombie(player, pos, difficulty));
  }

  public Object2IntMap<class_2382> countZombies() {
    var result = new Object2IntArrayMap<class_2382>();
    for (var entity : world.method_27909()) {
      if (!(entity instanceof ExtendedZombieEntity zombie)) continue;
      ZombieDensityMap.push(result, zombie.method_24515());
    }
    return result;
  }

  public static List<class_3222> players(class_3218 world) {
    return world.method_18766(
        class_1301.field_6157.and(class_1301.field_6155));
  }

  public void spawn(class_3218 world, boolean spawnMonsters) {
    this.world = world;
    if (!spawnMonsters
        || this.world.method_8407().equals(class_1267.field_5801)
        || !this.world.method_64395().method_8355(ZombieGamerules.DO_ZOMBIE_SPAWNING)) {
      return;
    }

    var players = players(world);
    var positions = players.stream().map(class_3222::method_24515).toList();
    this.zombieCount = countZombies();

    for (var player : players) {
      spawnZombiesNear(player, positions);
    }
  }

  public static boolean isApocalypticWorld(class_3218 world) {
    if (world.method_27983().equals(class_1937.field_25179)) return true;
    return false;
  }
}
