/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.zombies.difficulty.category;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.function.Function;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1282;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.codeberg.zenxarch.zombies.Zombies;
import org.codeberg.zenxarch.zombies.difficulty.CachedValue;
import org.codeberg.zenxarch.zombies.difficulty.DifficultyCategory;
import org.codeberg.zenxarch.zombies.difficulty.entry.CachedPlayerBasedDifficultyEntry;

public interface PlayerDeathsCategory {
    public static final AttachmentType<CachedValue> DEATH = CachedValue.createAttachmentType(Zombies.id("player_deaths/death_multiplier"));
    public static final CachedPlayerBasedDifficultyEntry DEATH_ENTRY = new CachedPlayerBasedDifficultyEntry(DEATH, PlayerDeathsCategory::getDifficulty, 1);
    public static final class_2960 PLAYER_DEATHS_CATEGORY = Zombies.id("player_deaths");
    public static final long TIME_WINDOW = 18000L;
    public static final int MAX_DEATHS = 10;
    public static final AttachmentType<LongArrayList> DEATH_TIMESTAMPS = AttachmentRegistry.create((class_2960)Zombies.id("player_death_timestamps"), builder -> builder.persistent(Codec.list((Codec)Codec.LONG).xmap(LongArrayList::new, Function.identity())).initializer(() -> new LongArrayList(10)).copyOnDeath());

    public static void initialize() {
        DifficultyCategory.addDifficultyEntry(PLAYER_DEATHS_CATEGORY, DEATH_ENTRY);
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, source) -> {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                PlayerDeathsCategory.recordPlayerDeath(player, source);
            }
        });
    }

    private static void recordPlayerDeath(class_3222 player, class_1282 source) {
        long time = player.method_51469().method_75260();
        LongArrayList deaths = (LongArrayList)player.getAttachedOrCreate(DEATH_TIMESTAMPS);
        deaths.add(time);
        PlayerDeathsCategory.trimDeaths(deaths, time);
    }

    private static int getAndUpdateDeathCount(class_3222 player) {
        return PlayerDeathsCategory.trimDeaths((LongArrayList)player.getAttachedOrCreate(DEATH_TIMESTAMPS), player.method_51469().method_75260());
    }

    private static int trimDeaths(LongArrayList deaths, long time) {
        int deathCount = PlayerDeathsCategory.countRecentDeaths(deaths, time);
        while (deaths.size() > deathCount) {
            deaths.removeFirst();
        }
        return deathCount;
    }

    private static int countRecentDeaths(LongArrayList deaths, long time) {
        int size = Math.min(deaths.size(), 10);
        for (int i = 0; i < size; ++i) {
            if (time - deaths.getLong(deaths.size() - 1 - i) <= 18000L) continue;
            return i;
        }
        return size;
    }

    private static double mapDeathsToDifficulty(int deathCount) {
        return class_3532.method_32854((double)deathCount, (double)3.0, (double)10.0, (double)1.0, (double)0.25);
    }

    private static double getDifficulty(class_3218 world, class_3222 player) {
        return PlayerDeathsCategory.mapDeathsToDifficulty(PlayerDeathsCategory.getAndUpdateDeathCount(player));
    }
}

