/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.zombies.spawning;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import org.codeberg.zenxarch.zombies.ZombieGamerules;
import org.codeberg.zenxarch.zombies.math.IntRange;
import org.codeberg.zenxarch.zombies.spawning.SpawnUtils;
import org.codeberg.zenxarch.zombies.spawning.ZombieDensityMap;
import org.codeberg.zenxarch.zombies.spawning.provider.PosRangeProvider;
import org.codeberg.zenxarch.zombies.spawning.provider.SpawnPosProvider;

public final class SpawnProvider {
    private static final class_5819 random = class_5819.method_43047();
    private static final int SQ_NEARBY_RANGE = 256;

    private SpawnProvider() {
        throw new IllegalStateException("Utility class");
    }

    private static boolean isTooCloseToAny(class_2338 b, List<class_2338> positions) {
        for (class_2338 pos : positions) {
            double sqDist = pos.method_10262((class_2382)b);
            if (!(sqDist < 256.0)) continue;
            return false;
        }
        return true;
    }

    private static Optional<class_2338> validate(class_3218 world, List<class_2338> positions, Optional<class_2338> pos) {
        return pos.filter(b -> SpawnProvider.isTooCloseToAny(b, positions)).filter(pz -> SpawnUtils.canSpawnAtPosBasic(world, pz));
    }

    private static boolean doesNotBlockMob(class_3218 world, class_2338 pos) {
        return world.method_8320(pos).method_26220((class_1922)world, pos).method_1110();
    }

    private static boolean doesNotContainFluid(class_3218 world, class_2338 pos) {
        return world.method_8316(pos).method_15769();
    }

    private static Optional<class_2338> adjustPos(class_3218 world, class_2338 ipos, IntRange yRange) {
        class_2338.class_2339 pos = ipos.method_25503();
        for (Integer y : yRange.iterate()) {
            pos.method_33098(y + 1);
            if (!SpawnProvider.doesNotBlockMob(world, (class_2338)pos)) {
                return Optional.of(pos.method_10084());
            }
            if (SpawnProvider.doesNotContainFluid(world, (class_2338)pos)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static IntRange getYRange(class_3218 world, class_2338 centerPos, class_2338 pos) {
        List<PosRangeProvider> providers = List.of(PosRangeProvider.AROUND_CENTER, PosRangeProvider.HEIGHTMAP_BOUNDS, PosRangeProvider.ZERO_BLOCKLIGHT);
        ArrayList<IntRange> ranges = new ArrayList<IntRange>(providers.size());
        for (PosRangeProvider provider : providers) {
            ranges.add(provider.get(world, pos, centerPos));
        }
        for (IntRange range : ranges) {
            if (range.isValid()) continue;
            return IntRange.INVALID;
        }
        IntRange result = (IntRange)ranges.get(0);
        for (int i = 1; i < ranges.size(); ++i) {
            if ((result = result.intersection((IntRange)ranges.get(i))).isValid()) continue;
            return IntRange.INVALID;
        }
        return result;
    }

    public static Optional<class_2338> giveSpawnPositions(class_3218 world, class_2338 centerPos, List<class_2338> positions, Object2IntMap<class_2382> densityMap, int toSpawn) {
        int spawnTries = toSpawn * 100 / (world.method_64395().method_8356(ZombieGamerules.SPAWN_SPEED) * 20);
        spawnTries = Math.max(spawnTries, 1);
        int maxDensity = ZombieDensityMap.getMaxDensity(toSpawn);
        for (class_2338 pos : SpawnPosProvider.MIXED.iterate(world, random, centerPos, toSpawn)) {
            if (SpawnUtils.burnsZombie(world, pos) || ZombieDensityMap.get(densityMap, pos) > maxDensity) continue;
            Optional<class_2338> adjustedPos = SpawnProvider.tryAdjustRandomPos(world, centerPos, pos);
            if (!(adjustedPos = SpawnProvider.validate(world, positions, adjustedPos)).isPresent()) continue;
            return adjustedPos;
        }
        return Optional.empty();
    }

    private static Optional<class_2338> tryAdjustRandomPos(class_3218 world, class_2338 origin, class_2338 pos) {
        IntRange range = SpawnProvider.getYRange(world, origin, pos);
        if (!range.isValid()) {
            return Optional.empty();
        }
        return SpawnProvider.adjustPos(world, pos, range);
    }
}

