/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.zombies;

import com.mojang.serialization.Codec;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentSyncPredicate;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityCombatEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.minecraft.class_1928;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_9135;
import org.codeberg.zenxarch.zombies.ZombieGamerules;
import org.codeberg.zenxarch.zombies.Zombies;

public interface ZombieHealth {
    public static final AttachmentType<Integer> ZOMBIE_KILLS = AttachmentRegistry.create((class_2960)Zombies.id("zombie_kills"), builder -> builder.persistent((Codec)Codec.INT).initializer(() -> 0).syncWith(class_9135.field_49675, AttachmentSyncPredicate.targetOnly()));

    public static void registerEvents() {
        ServerEntityCombatEvents.AFTER_KILLED_OTHER_ENTITY.register((world, self, dead, source) -> {
            if (self instanceof class_3222) {
                class_3222 player = (class_3222)self;
                if (dead.method_5864().method_20210(class_3483.field_46231)) {
                    ZombieHealth.onKillZombie(player);
                    ZombieHealth.updatePlayerStats(world, player);
                }
            }
        });
        ServerPlayerEvents.JOIN.register(player -> ZombieHealth.updatePlayerStats(player.method_51469(), player));
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> ZombieHealth.updatePlayerStats(newPlayer.method_51469(), newPlayer));
    }

    public static void updatePlayerStats(class_3218 world, class_3222 player) {
        class_1928 rules = world.method_64395();
        if (!rules.method_8355(ZombieGamerules.DO_ZOMBIE_KILLS_BASED_HEARTS)) {
            return;
        }
        float newMaxHealth = ZombieHealth.getNewMaxHealth((Integer)player.getAttachedOrCreate(ZOMBIE_KILLS), rules.method_8356(ZombieGamerules.ZOMBIE_KILLS_FOR_MAX_HEARTS), rules.method_8356(ZombieGamerules.MIN_HEARTS), rules.method_8356(ZombieGamerules.MAX_HEARTS));
        float newHealth = player.method_6032() / player.method_6063() * newMaxHealth;
        player.method_5996(class_5134.field_23716).method_6192((double)newMaxHealth);
        player.method_6033(newHealth);
    }

    private static float getNewMaxHealth(int kills, int maxKills, int minHearts, int maxHearts) {
        float delta = (float)kills / (float)maxKills;
        return (float)class_3532.method_15340((int)class_3532.method_48781((float)delta, (int)minHearts, (int)maxHearts), (int)minHearts, (int)maxHearts) * 2.0f;
    }

    private static void onKillZombie(class_3222 player) {
        Integer kills = (Integer)player.getAttachedOrCreate(ZOMBIE_KILLS);
        player.setAttached(ZOMBIE_KILLS, (Object)(kills + 1));
    }
}

