/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.zombies.client.debughud;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11630;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_746;
import org.codeberg.zenxarch.zombies.client.debughud.ZombieDebugHudEntry;
import org.codeberg.zenxarch.zombies.spawning.SpawnerAttachments;
import org.codeberg.zenxarch.zombies.spawning.ZombieApocalypse;
import org.codeberg.zenxarch.zombies.spawning.ZombieDensityMap;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ZombieCountDebugHudEntry
implements ZombieDebugHudEntry {
    public void method_72751(class_11630 lines, @Nullable class_1937 world, @Nullable class_2818 clientChunk, @Nullable class_2818 chunk) {
        if (world == null) {
            return;
        }
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_2338 pos = player.method_24515();
        int zombies = SpawnerAttachments.getApocalypses(serverWorld).stream().mapToInt(spawner -> this.getZombie((ZombieApocalypse)spawner, pos)).sum();
        this.addLine(lines, "Extended Zombies : " + zombies);
    }

    private int getZombie(ZombieApocalypse apocalypse, class_2338 center) {
        Object2IntMap<class_2382> zombieCount = apocalypse.getZombieCount();
        if (zombieCount == null) {
            return -1;
        }
        return ZombieDensityMap.getSubMap(zombieCount, center).values().intStream().sum();
    }
}

