/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.zombies.difficulty.category;

import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3483;
import net.minecraft.class_7923;
import org.codeberg.zenxarch.zombies.ZombieHealth;
import org.codeberg.zenxarch.zombies.Zombies;
import org.codeberg.zenxarch.zombies.difficulty.CachedValue;
import org.codeberg.zenxarch.zombies.difficulty.DifficultyCategory;
import org.codeberg.zenxarch.zombies.difficulty.entry.CachedPlayerBasedDifficultyEntry;

public interface KillCategory {
    public static final AttachmentType<CachedValue> ZOMBIE_KILLS = KillCategory.createCache("kills/zombie_kills");
    public static final AttachmentType<CachedValue> ZOMBIE_KILLS_SINCE_RESPAWN = KillCategory.createCache("kills/zombie_kills_since_respawn");
    public static final CachedPlayerBasedDifficultyEntry ZOMBIE_KILLS_ENTRY = new CachedPlayerBasedDifficultyEntry(ZOMBIE_KILLS, KillCategory::zombieKillScore, 10);
    public static final CachedPlayerBasedDifficultyEntry ZOMBIE_KILLS_SINCE_RESPAWN_ENTRY = new CachedPlayerBasedDifficultyEntry(ZOMBIE_KILLS_SINCE_RESPAWN, KillCategory::zombieKillScoreSinceRespawn, 1);
    public static final class_2960 KILL_CATEGORY = Zombies.id("kills");

    private static AttachmentType<CachedValue> createCache(String id) {
        return CachedValue.createAttachmentType(Zombies.id(id));
    }

    public static void initialize() {
        DifficultyCategory.addDifficultyEntry(KILL_CATEGORY, ZOMBIE_KILLS_ENTRY);
        DifficultyCategory.addDifficultyEntry(KILL_CATEGORY, ZOMBIE_KILLS_SINCE_RESPAWN_ENTRY);
    }

    private static double zombieKillScore(class_3218 world, class_3222 player) {
        return class_7923.field_41177.method_46733(class_3483.field_46231).map(list -> list.method_40239().mapToDouble(type -> KillCategory.getKillStat(player, (class_1299)type.comp_349())).sum() / 2500.0).orElse(0.0);
    }

    private static double zombieKillScoreSinceRespawn(class_3218 world, class_3222 player) {
        return (double)((Integer)player.getAttachedOrCreate(ZombieHealth.ZOMBIE_KILLS)).intValue() / 2500.0;
    }

    private static int getKillStat(class_3222 player, class_1299<?> type) {
        return player.method_14248().method_15025(class_3468.field_15403.method_14956(type));
    }
}

