/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.zombies.difficulty.category;

import net.minecraft.class_1267;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.codeberg.zenxarch.zombies.Zombies;
import org.codeberg.zenxarch.zombies.difficulty.DifficultyCategory;
import org.codeberg.zenxarch.zombies.difficulty.entry.DifficultyEntry;

public abstract class TimeCategory {
    private static final int TICKS_PER_HOUR = 72000;
    private static final int TICKS_PER_DAY = 24000;
    public static final DifficultyEntry DAYS_ENTRY = new DifficultyEntry(){

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public double calculate(class_3218 world, class_2791 chunk) {
            double dayFactor = TimeCategory.mapDays(world.method_8407(), TimeCategory.getDays(world));
            double moonSize = world.method_30272();
            return dayFactor * (1.0 + moonSize);
        }
    };
    public static final DifficultyEntry HOURS_ENTRY = new DifficultyEntry(){

        @Override
        public int getWeight() {
            return 10;
        }

        @Override
        public double calculate(class_3218 world, class_2791 chunk) {
            return TimeCategory.mapHours(world.method_8407(), TimeCategory.getHoursInhabited(world, chunk));
        }
    };
    public static final class_2960 DAYS_CATEGORY = Zombies.id("days");
    public static final class_2960 TIME_CATEGORY = Zombies.id("time");

    public static void initialize() {
        DifficultyCategory.addDifficultyEntry(DAYS_CATEGORY, DAYS_ENTRY);
        DifficultyCategory.addDifficultyEntry(TIME_CATEGORY, HOURS_ENTRY);
    }

    private static double normalize(double value, double start, double end) {
        return class_3532.method_32854((double)value, (double)start, (double)end, (double)0.0, (double)1.0);
    }

    private static double mapDays(class_1267 difficulty, double days) {
        return switch (difficulty) {
            default -> throw new MatchException(null, null);
            case class_1267.field_5801 -> 0.0;
            case class_1267.field_5805 -> TimeCategory.normalize(days, 5.0, 250.0);
            case class_1267.field_5802 -> TimeCategory.normalize(days, 2.0, 150.0);
            case class_1267.field_5807 -> TimeCategory.normalize(days, 0.0, 100.0);
        };
    }

    private static double mapHours(class_1267 difficulty, double hours) {
        double delta = switch (difficulty) {
            default -> throw new MatchException(null, null);
            case class_1267.field_5801 -> 0.0;
            case class_1267.field_5805 -> TimeCategory.normalize(hours, 8.0, 1.5);
            case class_1267.field_5802 -> TimeCategory.normalize(hours, 20.0, 1.5);
            case class_1267.field_5807 -> TimeCategory.normalize(hours, 35.0, 1.5);
        };
        return class_3532.method_16436((double)delta, (double)0.25, (double)1.0);
    }

    public static double getDays(class_3218 world) {
        return (double)world.method_8532() / 24000.0;
    }

    public static double getHoursInhabited(class_3218 world, class_2791 chunk) {
        return chunk.method_12033() / 72000L;
    }
}

