/*
 * Decompiled with CFR 0.152.
 */
package net.m998.magnetblocks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.m998.magnetblocks.MagnetBlock;
import net.m998.magnetblocks.ModBlockEntities;
import net.m998.magnetblocks.ModItems;
import net.m998.magnetblocks.PhantomMagnetManager;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1439;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1569;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1684;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class MagnetBlockEntity
extends class_2586 {
    private static final double RANGE = 40.0;
    private static final double FORCE = 0.001;
    private static final Map<class_1792, Double> ITEM_STRENGTH_MAP = new HashMap<class_1792, Double>();

    public MagnetBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.MAGNET_BLOCK_ENTITY, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.field_9236) {
            return;
        }
        if (!((Boolean)state.method_11654((class_2769)MagnetBlock.POWERED)).booleanValue()) {
            MagnetBlockEntity.processMagnetBlock(world, pos, state);
        }
        MagnetBlockEntity.processPhantomMagnets(world);
    }

    private static void processMagnetBlock(class_1937 world, class_2338 pos, class_2680 state) {
        class_243 blockCenter = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        boolean isAttracting = (Boolean)state.method_11654((class_2769)MagnetBlock.ATTRACTING);
        MagnetBlockEntity.applyMagneticForce(world, blockCenter, 40.0, 0.001, isAttracting);
    }

    private static void processPhantomMagnets(class_1937 world) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            MinecraftServer server = serverWorld.method_8503();
            PhantomMagnetManager manager = PhantomMagnetManager.get(server);
            for (PhantomMagnetManager.PhantomMagnet magnet : manager.getMagnets().values()) {
                class_243 magnetCenter = new class_243((double)magnet.getPos().method_10263() + 0.5, (double)magnet.getPos().method_10264() + 0.5, (double)magnet.getPos().method_10260() + 0.5);
                double force = 0.001 * magnet.getForceMultiplier();
                MagnetBlockEntity.applyMagneticForce(world, magnetCenter, magnet.getRadius(), force, magnet.isAttracting());
            }
        }
    }

    private static void applyMagneticForce(class_1937 world, class_243 center, double range, double baseForce, boolean isAttracting) {
        class_238 area = new class_238(center.field_1352 - range, center.field_1351 - range, center.field_1350 - range, center.field_1352 + range, center.field_1351 + range, center.field_1350 + range);
        List entities = world.method_18467(class_1297.class, area);
        for (class_1297 entity : entities) {
            class_243 entityPos;
            double distance;
            double strength = MagnetBlockEntity.getEntityStrength(entity);
            if (strength <= 0.0 || !((distance = (entityPos = entity.method_19538()).method_1022(center)) <= range) || !(distance > 1.5)) continue;
            class_243 direction = isAttracting ? center.method_1020(entityPos).method_1029() : entityPos.method_1020(center).method_1029();
            double forceMultiplier = 1.0 - distance / range;
            double strengthMultiplier = Math.max(0.01, Math.min(strength, 5.0));
            class_243 velocity = direction.method_1021(baseForce * forceMultiplier * strengthMultiplier);
            entity.method_5762(velocity.field_1352, velocity.field_1351, velocity.field_1350);
            entity.field_6037 = true;
            if (world.field_9229.method_43048(10) != 0) continue;
            if (isAttracting) {
                world.method_8406((class_2394)class_2398.field_29644, entityPos.field_1352, entityPos.field_1351 + (double)(entity.method_17682() / 2.0f), entityPos.field_1350, velocity.field_1352 * 0.1, velocity.field_1351 * 0.1, velocity.field_1350 * 0.1);
                continue;
            }
            world.method_8406((class_2394)class_2398.field_22246, entityPos.field_1352, entityPos.field_1351 + (double)(entity.method_17682() / 2.0f), entityPos.field_1350, velocity.field_1352 * 0.1, velocity.field_1351 * 0.1, velocity.field_1350 * 0.1);
        }
    }

    private static double getEntityStrength(class_1297 entity) {
        if (entity instanceof class_1439) {
            return 3.0;
        }
        if (entity instanceof class_1684) {
            return 1.5;
        }
        if (entity instanceof class_1540) {
            class_1540 fallingBlock = (class_1540)entity;
            return MagnetBlockEntity.getFallingBlockStrength(fallingBlock);
        }
        if (entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            return MagnetBlockEntity.getItemStrength(itemEntity.method_6983());
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.method_7337() || player.method_7325()) {
                return 0.0;
            }
            return MagnetBlockEntity.getPlayerStrength(player);
        }
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            double equipmentStrength = MagnetBlockEntity.getMobEquipmentStrength(living);
            double baseStrength = MagnetBlockEntity.getMobBaseStrength(living);
            return Math.max(equipmentStrength, baseStrength);
        }
        return 0.0;
    }

    private static double getFallingBlockStrength(class_1540 fallingBlock) {
        class_2680 blockState = fallingBlock.method_6962();
        String blockName = blockState.method_26204().method_9539().toLowerCase();
        if (blockName.contains("anvil")) {
            return 4.0;
        }
        return 0.0;
    }

    private static double getMobEquipmentStrength(class_1309 mob) {
        double totalStrength = 0.0;
        int magneticItems = 0;
        for (class_1799 stack : mob.method_5661()) {
            double strength = MagnetBlockEntity.getItemStrength(stack);
            if (!(strength > 0.0)) continue;
            totalStrength += strength;
            ++magneticItems;
        }
        class_1799 mainHand = mob.method_6047();
        double mainHandStrength = MagnetBlockEntity.getItemStrength(mainHand);
        if (mainHandStrength > 0.0) {
            totalStrength += mainHandStrength;
            ++magneticItems;
        }
        return magneticItems > 0 ? totalStrength / (double)magneticItems : 0.0;
    }

    private static double getMobBaseStrength(class_1309 mob) {
        if (mob instanceof class_1569) {
            return 0.5;
        }
        if (mob instanceof class_1429) {
            return 0.3;
        }
        if (mob instanceof class_1646) {
            return 0.4;
        }
        return 0.2;
    }

    private static double getPlayerStrength(class_1657 player) {
        double armorStrength = MagnetBlockEntity.getArmorStrength(player);
        double heldItemStrength = MagnetBlockEntity.getHeldItemStrength(player);
        return Math.max(armorStrength, heldItemStrength);
    }

    private static double getArmorStrength(class_1657 player) {
        double totalStrength = 0.0;
        int armorPieces = 0;
        for (class_1799 armorStack : player.method_5661()) {
            double pieceStrength = MagnetBlockEntity.getItemStrength(armorStack);
            if (!(pieceStrength > 0.0)) continue;
            totalStrength += pieceStrength;
            ++armorPieces;
        }
        return armorPieces >= 2 ? totalStrength / (double)armorPieces : 0.0;
    }

    private static double getHeldItemStrength(class_1657 player) {
        return Math.max(MagnetBlockEntity.getItemStrength(player.method_6047()), MagnetBlockEntity.getItemStrength(player.method_6079()));
    }

    private static double getItemStrength(class_1799 stack) {
        if (stack.method_7960()) {
            return 0.0;
        }
        if (stack.method_7909() == ModItems.MAGNET_ITEM) {
            return 5.0;
        }
        Double strength = ITEM_STRENGTH_MAP.get(stack.method_7909());
        return strength != null ? strength : 0.0;
    }

    private static void initializeItemStrengthMap() {
        ITEM_STRENGTH_MAP.put(class_1802.field_8782, 4.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_8750, 3.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8427, 3.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_22018, 5.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_22020, 3.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_22022, 3.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_22025, 3.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_22024, 3.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_22023, 3.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_22026, 3.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_22027, 3.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_22028, 4.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_22029, 3.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_22030, 3.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_22021, 3.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_22019, 2.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8634, 1.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_8449, 1.2);
        ITEM_STRENGTH_MAP.put(class_1802.field_8773, 3.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_33505, 2.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8594, 2.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_8241, 1.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8076, 1.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_23983, 0.8);
        ITEM_STRENGTH_MAP.put(class_1802.field_8239, 2.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8638, 2.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_8550, 1.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_8045, 2.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8129, 0.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8848, 1.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_8211, 1.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_8655, 1.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_8371, 2.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_8475, 2.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_8403, 2.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_8699, 1.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8609, 1.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8868, 1.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_8884, 0.3);
        ITEM_STRENGTH_MAP.put(class_1802.field_8743, 1.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8523, 2.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8396, 2.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_8660, 1.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8578, 2.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_8620, 1.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_33400, 0.8);
        ITEM_STRENGTH_MAP.put(class_1802.field_8675, 0.3);
        ITEM_STRENGTH_MAP.put(class_1802.field_8599, 0.8);
        ITEM_STRENGTH_MAP.put(class_1802.field_29020, 0.8);
        ITEM_STRENGTH_MAP.put(class_1802.field_8251, 0.7);
        ITEM_STRENGTH_MAP.put(class_1802.field_8249, 1.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8105, 1.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8366, 0.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8388, 2.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8063, 3.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_8069, 2.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8836, 3.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_16308, 2.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_40864, 1.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_8592, 1.8);
        ITEM_STRENGTH_MAP.put(class_1802.field_8187, 1.3);
        ITEM_STRENGTH_MAP.put(class_1802.field_8705, 1.1);
        ITEM_STRENGTH_MAP.put(class_1802.field_8103, 1.1);
        ITEM_STRENGTH_MAP.put(class_1802.field_27876, 1.1);
        ITEM_STRENGTH_MAP.put(class_1802.field_28354, 1.1);
        ITEM_STRENGTH_MAP.put(class_1802.field_8666, 1.1);
        ITEM_STRENGTH_MAP.put(class_1802.field_8714, 1.1);
        ITEM_STRENGTH_MAP.put(class_1802.field_8478, 1.1);
        ITEM_STRENGTH_MAP.put(class_1802.field_8108, 1.1);
        ITEM_STRENGTH_MAP.put(class_1802.field_37533, 1.1);
        ITEM_STRENGTH_MAP.put(class_1802.field_16539, 0.9);
        ITEM_STRENGTH_MAP.put(class_1802.field_22016, 0.9);
        ITEM_STRENGTH_MAP.put(class_1802.field_8255, 1.8);
        ITEM_STRENGTH_MAP.put(class_1802.field_8175, 0.8);
        ITEM_STRENGTH_MAP.put(class_1802.field_8725, 0.1);
        ITEM_STRENGTH_MAP.put(class_1802.field_8793, 0.3);
        ITEM_STRENGTH_MAP.put(class_1802.field_8619, 0.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8857, 0.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8537, 1.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_23256, 4.0);
    }

    static {
        MagnetBlockEntity.initializeItemStrengthMap();
    }
}

