/*
 * Decompiled with CFR 0.152.
 */
package net.m998.magnetblocks;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_18;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class PhantomMagnetManager
extends class_18 {
    private static final String DATA_NAME = "magnetblocks_phantom_magnets";
    private static final double MAX_FORCE_MULTIPLIER = 10.0;
    private final Map<Integer, PhantomMagnet> magnets = new HashMap<Integer, PhantomMagnet>();
    private int nextId = 1;
    private boolean clearConfirmation = false;

    public static PhantomMagnetManager get(MinecraftServer server) {
        class_3218 world = server.method_30002();
        return (PhantomMagnetManager)world.method_17983().method_17924(PhantomMagnetManager::fromNbt, PhantomMagnetManager::new, DATA_NAME);
    }

    public int createMagnet(class_2338 pos, double radius, double forceMultiplier, boolean attracting) {
        int id = this.findNextAvailableId();
        double clampedForce = Math.min(forceMultiplier, 10.0);
        this.magnets.put(id, new PhantomMagnet(pos, radius, clampedForce, attracting));
        if (id >= this.nextId) {
            this.nextId = id + 1;
        }
        this.method_80();
        return id;
    }

    private int findNextAvailableId() {
        if (this.magnets.isEmpty()) {
            return 1;
        }
        for (int i = 1; i <= this.nextId + 1; ++i) {
            if (this.magnets.containsKey(i)) continue;
            return i;
        }
        return this.nextId;
    }

    public boolean removeMagnet(int id) {
        boolean removed;
        boolean bl = removed = this.magnets.remove(id) != null;
        if (removed) {
            if (id == this.nextId - 1) {
                this.nextId = id;
                while (this.nextId > 1 && !this.magnets.containsKey(this.nextId - 1)) {
                    --this.nextId;
                }
            }
            this.method_80();
        }
        return removed;
    }

    public Map<Integer, PhantomMagnet> getMagnets() {
        return this.magnets;
    }

    public void clearAllMagnets(boolean confirm) {
        if (confirm) {
            this.magnets.clear();
            this.nextId = 1;
            this.clearConfirmation = false;
            this.method_80();
        } else {
            this.clearConfirmation = true;
        }
    }

    public boolean isClearConfirmationPending() {
        return this.clearConfirmation;
    }

    public static double getMaxForceMultiplier() {
        return 10.0;
    }

    public class_2487 method_75(class_2487 nbt) {
        nbt.method_10569("nextId", this.nextId);
        nbt.method_10556("clearConfirmation", this.clearConfirmation);
        class_2499 magnetsList = new class_2499();
        for (Map.Entry<Integer, PhantomMagnet> entry : this.magnets.entrySet()) {
            class_2487 magnetNbt = new class_2487();
            magnetNbt.method_10569("id", entry.getKey().intValue());
            magnetNbt.method_10566("magnet", (class_2520)entry.getValue().toNbt());
            magnetsList.add((Object)magnetNbt);
        }
        nbt.method_10566("magnets", (class_2520)magnetsList);
        return nbt;
    }

    public static PhantomMagnetManager fromNbt(class_2487 nbt) {
        PhantomMagnetManager manager = new PhantomMagnetManager();
        manager.nextId = nbt.method_10550("nextId");
        manager.clearConfirmation = nbt.method_10577("clearConfirmation");
        class_2499 magnetsList = nbt.method_10554("magnets", 10);
        for (int i = 0; i < magnetsList.size(); ++i) {
            class_2487 magnetEntry = magnetsList.method_10602(i);
            int id = magnetEntry.method_10550("id");
            PhantomMagnet magnet = PhantomMagnet.fromNbt(magnetEntry.method_10562("magnet"));
            manager.magnets.put(id, magnet);
        }
        return manager;
    }

    public static class PhantomMagnet {
        private final class_2338 pos;
        private double radius;
        private double forceMultiplier;
        private boolean attracting;

        public PhantomMagnet(class_2338 pos, double radius, double forceMultiplier, boolean attracting) {
            this.pos = pos;
            this.radius = radius;
            this.forceMultiplier = Math.min(forceMultiplier, 10.0);
            this.attracting = attracting;
        }

        public class_2338 getPos() {
            return this.pos;
        }

        public double getRadius() {
            return this.radius;
        }

        public double getForceMultiplier() {
            return this.forceMultiplier;
        }

        public boolean isAttracting() {
            return this.attracting;
        }

        public void setRadius(double radius) {
            this.radius = radius;
        }

        public void setForceMultiplier(double forceMultiplier) {
            this.forceMultiplier = Math.min(forceMultiplier, 10.0);
        }

        public void setAttracting(boolean attracting) {
            this.attracting = attracting;
        }

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10569("x", this.pos.method_10263());
            nbt.method_10569("y", this.pos.method_10264());
            nbt.method_10569("z", this.pos.method_10260());
            nbt.method_10549("radius", this.radius);
            nbt.method_10549("forceMultiplier", this.forceMultiplier);
            nbt.method_10556("attracting", this.attracting);
            return nbt;
        }

        public static PhantomMagnet fromNbt(class_2487 nbt) {
            class_2338 pos = new class_2338(nbt.method_10550("x"), nbt.method_10550("y"), nbt.method_10550("z"));
            double radius = nbt.method_10574("radius");
            double forceMultiplier = Math.min(nbt.method_10574("forceMultiplier"), 10.0);
            boolean attracting = nbt.method_10577("attracting");
            return new PhantomMagnet(pos, radius, forceMultiplier, attracting);
        }
    }
}

