/*
 * Decompiled with CFR 0.152.
 */
package net.m998.magnetblocks;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.m998.magnetblocks.MagnetStorms;
import net.m998.magnetblocks.MagnetWhitelistManager;
import net.m998.magnetblocks.MagneticStormManager;
import net.m998.magnetblocks.PhantomMagnetManager;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class MagnetCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"magnet").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"radius", (ArgumentType)DoubleArgumentType.doubleArg((double)1.0, (double)500.0)).then(class_2170.method_9244((String)"forceMultiplier", (ArgumentType)DoubleArgumentType.doubleArg((double)0.01, (double)10.0)).then(class_2170.method_9244((String)"attracting", (ArgumentType)BoolArgumentType.bool()).executes(context -> MagnetCommands.createPhantomMagnet((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"pos"), DoubleArgumentType.getDouble((CommandContext)context, (String)"radius"), DoubleArgumentType.getDouble((CommandContext)context, (String)"forceMultiplier"), BoolArgumentType.getBool((CommandContext)context, (String)"attracting"))))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer()).executes(context -> MagnetCommands.removePhantomMagnet((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"id")))))).then(class_2170.method_9247((String)"modify").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9247((String)"range").then(class_2170.method_9244((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)1.0, (double)500.0)).executes(context -> MagnetCommands.modifyMagnetRange((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"id"), DoubleArgumentType.getDouble((CommandContext)context, (String)"value")))))).then(class_2170.method_9247((String)"force").then(class_2170.method_9244((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.01, (double)10.0)).executes(context -> MagnetCommands.modifyMagnetForce((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"id"), DoubleArgumentType.getDouble((CommandContext)context, (String)"value")))))).then(class_2170.method_9247((String)"polarity").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> MagnetCommands.modifyMagnetPolarity((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"id"), BoolArgumentType.getBool((CommandContext)context, (String)"value")))))))).then(class_2170.method_9247((String)"list").executes(MagnetCommands::listPhantomMagnets))).then(class_2170.method_9247((String)"clear").executes(MagnetCommands::clearAllPhantomMagnets))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"whitelist").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"strength", (ArgumentType)DoubleArgumentType.doubleArg((double)0.001, (double)5.0)).executes(context -> MagnetCommands.whitelistAdd((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"player"), DoubleArgumentType.getDouble((CommandContext)context, (String)"strength"))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).executes(context -> MagnetCommands.whitelistRemove((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"list").executes(MagnetCommands::whitelistList)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"admin").requires(source -> source.method_9259(3))).then(class_2170.method_9247((String)"info").then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer()).executes(context -> MagnetCommands.adminMagnetInfo((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"id")))))).then(class_2170.method_9247((String)"debug").executes(MagnetCommands::adminDebugInfo))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"storm").executes(MagnetCommands::adminStormInfo)).then(class_2170.method_9247((String)"start").then(class_2170.method_9244((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1, (int)120)).then(class_2170.method_9244((String)"intensity", (ArgumentType)DoubleArgumentType.doubleArg((double)0.1, (double)5.0)).executes(context -> MagnetCommands.adminStormStart((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), DoubleArgumentType.getDouble((CommandContext)context, (String)"intensity"))))))).then(class_2170.method_9247((String)"stop").executes(MagnetCommands::adminStormStop))).then(class_2170.method_9247((String)"force").executes(MagnetCommands::adminStormForceRandom))).then(class_2170.method_9247((String)"enable").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> MagnetCommands.adminStormEnable((CommandContext<class_2168>)context, BoolArgumentType.getBool((CommandContext)context, (String)"value")))))).then(class_2170.method_9247((String)"status").executes(MagnetCommands::adminStormStatus)))));
    }

    private static int createPhantomMagnet(CommandContext<class_2168> context, class_2338 pos, double radius, double forceMultiplier, boolean attracting) {
        PhantomMagnetManager manager = PhantomMagnetManager.get(((class_2168)context.getSource()).method_9211());
        int id = manager.createMagnet(pos, radius, forceMultiplier, attracting);
        double actualForce = Math.min(forceMultiplier, PhantomMagnetManager.getMaxForceMultiplier());
        if (forceMultiplier > actualForce) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.create.force_limited", (Object[])new Object[]{forceMultiplier, actualForce}), false);
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.create.success", (Object[])new Object[]{id, pos.method_23854(), radius, actualForce, attracting ? class_2561.method_43471((String)"command.magnetblocks.polarity.attracting") : class_2561.method_43471((String)"command.magnetblocks.polarity.repelling")}), true);
        return id;
    }

    private static int removePhantomMagnet(CommandContext<class_2168> context, int id) {
        PhantomMagnetManager manager = PhantomMagnetManager.get(((class_2168)context.getSource()).method_9211());
        boolean removed = manager.removeMagnet(id);
        if (removed) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.remove.success", (Object[])new Object[]{id}), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.magnetblocks.remove.error", (Object[])new Object[]{id}));
        return 0;
    }

    private static int modifyMagnetRange(CommandContext<class_2168> context, int id, double newRange) {
        PhantomMagnetManager manager = PhantomMagnetManager.get(((class_2168)context.getSource()).method_9211());
        PhantomMagnetManager.PhantomMagnet magnet = manager.getMagnets().get(id);
        if (magnet != null) {
            magnet.setRadius(newRange);
            manager.method_80();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.modify.range.success", (Object[])new Object[]{id, newRange}), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.magnetblocks.modify.error.not_found", (Object[])new Object[]{id}));
        return 0;
    }

    private static int modifyMagnetForce(CommandContext<class_2168> context, int id, double newForce) {
        PhantomMagnetManager manager = PhantomMagnetManager.get(((class_2168)context.getSource()).method_9211());
        PhantomMagnetManager.PhantomMagnet magnet = manager.getMagnets().get(id);
        if (magnet != null) {
            double actualForce = Math.min(newForce, PhantomMagnetManager.getMaxForceMultiplier());
            magnet.setForceMultiplier(actualForce);
            manager.method_80();
            if (newForce > actualForce) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.modify.force_limited", (Object[])new Object[]{newForce, actualForce}), false);
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.modify.force.success", (Object[])new Object[]{id, actualForce}), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.magnetblocks.modify.error.not_found", (Object[])new Object[]{id}));
        return 0;
    }

    private static int modifyMagnetPolarity(CommandContext<class_2168> context, int id, boolean newPolarity) {
        PhantomMagnetManager manager = PhantomMagnetManager.get(((class_2168)context.getSource()).method_9211());
        PhantomMagnetManager.PhantomMagnet magnet = manager.getMagnets().get(id);
        if (magnet != null) {
            magnet.setAttracting(newPolarity);
            manager.method_80();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.modify.polarity.success", (Object[])new Object[]{id, newPolarity ? class_2561.method_43471((String)"command.magnetblocks.polarity.attracting") : class_2561.method_43471((String)"command.magnetblocks.polarity.repelling")}), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.magnetblocks.modify.error.not_found", (Object[])new Object[]{id}));
        return 0;
    }

    private static int listPhantomMagnets(CommandContext<class_2168> context) {
        PhantomMagnetManager manager = PhantomMagnetManager.get(((class_2168)context.getSource()).method_9211());
        Map<Integer, PhantomMagnetManager.PhantomMagnet> magnets = manager.getMagnets();
        if (magnets.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.magnetblocks.list.empty"), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.list.header", (Object[])new Object[]{magnets.size()}), false);
            for (Map.Entry<Integer, PhantomMagnetManager.PhantomMagnet> entry : magnets.entrySet()) {
                PhantomMagnetManager.PhantomMagnet magnet = entry.getValue();
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.list.entry", (Object[])new Object[]{entry.getKey(), magnet.getPos().method_23854(), magnet.getRadius(), magnet.getForceMultiplier(), magnet.isAttracting() ? class_2561.method_43471((String)"command.magnetblocks.polarity.attracting") : class_2561.method_43471((String)"command.magnetblocks.polarity.repelling")}), false);
            }
        }
        return magnets.size();
    }

    private static int clearAllPhantomMagnets(CommandContext<class_2168> context) {
        PhantomMagnetManager manager = PhantomMagnetManager.get(((class_2168)context.getSource()).method_9211());
        if (manager.isClearConfirmationPending()) {
            manager.clearAllMagnets(true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.clear.success", (Object[])new Object[]{manager.getMagnets().size()}), true);
            return 1;
        }
        manager.clearAllMagnets(false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.magnetblocks.clear.confirm"), true);
        return 0;
    }

    private static int whitelistAdd(CommandContext<class_2168> context, String playerName, double strength) {
        try {
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            UUID playerUUID = ((GameProfile)Objects.requireNonNull(server.method_3793()).method_14515(playerName).orElseThrow()).getId();
            MagnetWhitelistManager whitelistManager = MagnetWhitelistManager.get(server);
            whitelistManager.addPlayer(playerUUID, strength);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.whitelist.add.success", (Object[])new Object[]{playerName, strength}), true);
            return 1;
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.magnetblocks.whitelist.add.error", (Object[])new Object[]{playerName}));
            return 0;
        }
    }

    private static int whitelistRemove(CommandContext<class_2168> context, String playerName) {
        try {
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            UUID playerUUID = ((GameProfile)Objects.requireNonNull(server.method_3793()).method_14515(playerName).orElseThrow()).getId();
            MagnetWhitelistManager whitelistManager = MagnetWhitelistManager.get(server);
            boolean removed = whitelistManager.removePlayer(playerUUID);
            if (removed) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.whitelist.remove.success", (Object[])new Object[]{playerName}), true);
                return 1;
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.magnetblocks.whitelist.remove.error", (Object[])new Object[]{playerName}));
            return 0;
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.magnetblocks.whitelist.remove.error", (Object[])new Object[]{playerName}));
            return 0;
        }
    }

    private static int whitelistList(CommandContext<class_2168> context) {
        MagnetWhitelistManager whitelistManager = MagnetWhitelistManager.get(((class_2168)context.getSource()).method_9211());
        Map<UUID, MagnetWhitelistManager.WhitelistEntry> whitelist = whitelistManager.getWhitelist();
        if (whitelist.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.magnetblocks.whitelist.list.empty"), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.whitelist.list.header", (Object[])new Object[]{whitelist.size()}), false);
            for (Map.Entry<UUID, MagnetWhitelistManager.WhitelistEntry> entry : whitelist.entrySet()) {
                String playerName = Objects.requireNonNull(((class_2168)context.getSource()).method_9211().method_3793()).method_14512(entry.getKey()).map(GameProfile::getName).orElse("Unknown");
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.whitelist.list.entry", (Object[])new Object[]{playerName, ((MagnetWhitelistManager.WhitelistEntry)entry.getValue()).getStrength()}), false);
            }
        }
        return whitelist.size();
    }

    private static int adminMagnetInfo(CommandContext<class_2168> context, int id) {
        PhantomMagnetManager manager = PhantomMagnetManager.get(((class_2168)context.getSource()).method_9211());
        PhantomMagnetManager.PhantomMagnet magnet = manager.getMagnets().get(id);
        if (magnet != null) {
            class_2338 pos = magnet.getPos();
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            String blockName = world.method_8320(pos).method_26204().method_9539();
            String biomeName = world.method_23753(pos).method_40230().map(key -> key.method_29177().toString()).orElse("unknown");
            ((class_2168)context.getSource()).method_9226(() -> MagnetCommands.lambda$adminMagnetInfo$30(id, pos, magnet, blockName, biomeName, (class_1937)world), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.magnetblocks.modify.error.not_found", (Object[])new Object[]{id}));
        return 0;
    }

    private static int adminDebugInfo(CommandContext<class_2168> context) {
        PhantomMagnetManager manager = PhantomMagnetManager.get(((class_2168)context.getSource()).method_9211());
        Map<Integer, PhantomMagnetManager.PhantomMagnet> magnets = manager.getMagnets();
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        String playerName = player != null ? player.method_7334().getName() : "Console";
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.magnetblocks.admin.debug.header"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.admin.debug.player", (Object[])new Object[]{playerName}), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.admin.debug.magnets_count", (Object[])new Object[]{magnets.size()}), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.admin.debug.next_id", (Object[])new Object[]{manager.getMagnets().isEmpty() ? 1 : manager.getMagnets().keySet().stream().max(Integer::compareTo).orElse(0) + 1}), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.admin.debug.clear_pending", (Object[])new Object[]{manager.isClearConfirmationPending()}), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.admin.debug.max_force", (Object[])new Object[]{PhantomMagnetManager.getMaxForceMultiplier()}), false);
        return 1;
    }

    private static int adminStormInfo(CommandContext<class_2168> context) {
        MagneticStormManager stormManager = MagneticStormManager.get(((class_2168)context.getSource()).method_9211());
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.magnetblocks.admin.storm.header"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.admin.storm.active", (Object[])new Object[]{stormManager.isStormActive()}), false);
        if (stormManager.isStormActive()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.admin.storm.effect", (Object[])new Object[]{stormManager.getCurrentEffect() != null ? stormManager.getCurrentEffect().name() : "unknown"}), false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.admin.storm.time_remaining", (Object[])new Object[]{stormManager.getStormTimeRemaining() / 60000L}), false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.admin.storm.intensity", (Object[])new Object[]{stormManager.getStormIntensity()}), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.admin.storm.time_until", (Object[])new Object[]{stormManager.getTimeUntilNextStorm() / 60000L}), false);
        }
        return 1;
    }

    private static int adminStormStart(CommandContext<class_2168> context, int duration, double intensity) {
        MagneticStormManager stormManager = MagneticStormManager.get(((class_2168)context.getSource()).method_9211());
        if (stormManager.isStormActive()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.magnetblocks.admin.storm.start.error.active"));
            return 0;
        }
        stormManager.startCustomStorm(((class_2168)context.getSource()).method_9211(), duration, intensity);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.admin.storm.start.success", (Object[])new Object[]{duration, intensity}), true);
        return 1;
    }

    private static int adminStormStop(CommandContext<class_2168> context) {
        MagneticStormManager stormManager = MagneticStormManager.get(((class_2168)context.getSource()).method_9211());
        if (!stormManager.isStormActive()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.magnetblocks.admin.storm.stop.error.inactive"));
            return 0;
        }
        stormManager.endStorm(((class_2168)context.getSource()).method_9211());
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.magnetblocks.admin.storm.stop.success"), true);
        return 1;
    }

    private static int adminStormForceRandom(CommandContext<class_2168> context) {
        MagneticStormManager stormManager = MagneticStormManager.get(((class_2168)context.getSource()).method_9211());
        if (stormManager.isStormActive()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.magnetblocks.admin.storm.force.error.active"));
            return 0;
        }
        stormManager.startStorm(((class_2168)context.getSource()).method_9211());
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.magnetblocks.admin.storm.force.success"), true);
        return 1;
    }

    private static int adminStormEnable(CommandContext<class_2168> context, boolean enable) {
        MagnetStorms.ENABLE_MAGNETIC_STORMS = enable;
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)("command.magnetblocks.admin.storm." + (enable ? "enabled" : "disabled"))), true);
        return 1;
    }

    private static int adminStormStatus(CommandContext<class_2168> context) {
        boolean stormsEnabled = MagnetStorms.ENABLE_MAGNETIC_STORMS;
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.magnetblocks.admin.storm.status", (Object[])new Object[]{stormsEnabled ? "enabled" : "disabled"}), false);
        return 1;
    }

    private static /* synthetic */ class_2561 lambda$adminMagnetInfo$30(int id, class_2338 pos, PhantomMagnetManager.PhantomMagnet magnet, String blockName, String biomeName, class_1937 world) {
        return class_2561.method_43469((String)"command.magnetblocks.admin.info.detailed", (Object[])new Object[]{id, pos.method_23854(), magnet.getRadius(), magnet.getForceMultiplier(), magnet.isAttracting() ? class_2561.method_43471((String)"command.magnetblocks.polarity.attracting") : class_2561.method_43471((String)"command.magnetblocks.polarity.repelling"), class_2561.method_43471((String)blockName), biomeName, world.method_27983().method_29177().toString()});
    }
}

