/*
 * Decompiled with CFR 0.152.
 */
package net.m998.magnetblocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.m998.magnetblocks.MagnetStorms;
import net.m998.magnetblocks.PhantomMagnetManager;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class MagneticStormManager
extends class_18 {
    private static final String DATA_NAME = "magnetblocks_storms";
    private long lastStormEndTime = 0L;
    private long nextStormTime = 0L;
    private boolean stormActive = false;
    private long stormEndTime = 0L;
    private StormEffect currentEffect = null;
    private double stormIntensity = 1.0;
    private boolean isCustomStorm = false;
    private final Map<Integer, MagnetBackup> magnetBackups = new HashMap<Integer, MagnetBackup>();
    private final Random random = new Random();

    public MagneticStormManager() {
        this.scheduleNextStorm();
    }

    public static MagneticStormManager get(MinecraftServer server) {
        class_3218 world = server.method_30002();
        return (MagneticStormManager)world.method_17983().method_17924(MagneticStormManager::fromNbt, MagneticStormManager::new, DATA_NAME);
    }

    public void tick(MinecraftServer server) {
        if (!MagnetStorms.ENABLE_MAGNETIC_STORMS) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.stormActive) {
            if (currentTime >= this.stormEndTime) {
                this.endStorm(server);
            }
        } else if (!this.isCustomStorm && currentTime >= this.nextStormTime) {
            this.startStorm(server);
        }
    }

    public void startStorm(MinecraftServer server) {
        if (this.stormActive) {
            return;
        }
        this.saveMagnetBackups(server);
        this.stormActive = true;
        this.isCustomStorm = false;
        this.stormIntensity = 1.0;
        this.currentEffect = this.getRandomStormEffect();
        int durationMinutes = 4 + this.random.nextInt(13);
        this.stormEndTime = System.currentTimeMillis() + (long)durationMinutes * 60L * 1000L;
        this.applyStormEffect(server);
        this.method_80();
        System.out.println("Magnetic storm started! Effect: " + String.valueOf((Object)this.currentEffect) + ", Duration: " + durationMinutes + "min");
    }

    public void startCustomStorm(MinecraftServer server, int durationMinutes, double intensity) {
        if (this.stormActive) {
            return;
        }
        this.saveMagnetBackups(server);
        this.stormActive = true;
        this.isCustomStorm = true;
        this.stormIntensity = Math.min(intensity, 5.0);
        this.currentEffect = this.getRandomStormEffect();
        this.stormEndTime = System.currentTimeMillis() + (long)durationMinutes * 60L * 1000L;
        this.applyStormEffect(server);
        this.method_80();
        System.out.println("Custom magnetic storm started! Effect: " + String.valueOf((Object)this.currentEffect) + ", Duration: " + durationMinutes + "min, Intensity: " + intensity);
    }

    public void endStorm(MinecraftServer server) {
        if (!this.stormActive) {
            return;
        }
        this.restoreMagnetBackups(server);
        this.stormActive = false;
        this.stormIntensity = 1.0;
        this.lastStormEndTime = System.currentTimeMillis();
        this.magnetBackups.clear();
        if (!this.isCustomStorm) {
            this.scheduleNextStorm();
        }
        this.isCustomStorm = false;
        this.method_80();
        System.out.println("Magnetic storm ended. Magnets restored to original settings.");
    }

    private void saveMagnetBackups(MinecraftServer server) {
        PhantomMagnetManager magnetManager = PhantomMagnetManager.get(server);
        Map<Integer, PhantomMagnetManager.PhantomMagnet> magnets = magnetManager.getMagnets();
        this.magnetBackups.clear();
        for (Map.Entry<Integer, PhantomMagnetManager.PhantomMagnet> entry : magnets.entrySet()) {
            int magnetId = entry.getKey();
            PhantomMagnetManager.PhantomMagnet magnet = entry.getValue();
            MagnetBackup backup = new MagnetBackup(magnet.getRadius(), magnet.getForceMultiplier(), magnet.isAttracting());
            this.magnetBackups.put(magnetId, backup);
        }
        System.out.println("Saved backups for " + this.magnetBackups.size() + " magnets");
    }

    private void restoreMagnetBackups(MinecraftServer server) {
        PhantomMagnetManager magnetManager = PhantomMagnetManager.get(server);
        Map<Integer, PhantomMagnetManager.PhantomMagnet> magnets = magnetManager.getMagnets();
        int restoredCount = 0;
        for (Map.Entry<Integer, PhantomMagnetManager.PhantomMagnet> entry : magnets.entrySet()) {
            int magnetId = entry.getKey();
            PhantomMagnetManager.PhantomMagnet magnet = entry.getValue();
            MagnetBackup backup = this.magnetBackups.get(magnetId);
            if (backup == null) continue;
            magnet.setRadius(backup.radius);
            magnet.setForceMultiplier(backup.forceMultiplier);
            magnet.setAttracting(backup.attracting);
            ++restoredCount;
        }
        magnetManager.method_80();
        System.out.println("Restored " + restoredCount + " magnets to original settings");
    }

    private void scheduleNextStorm() {
        int intervalMinutes = 180 + this.random.nextInt(181);
        this.nextStormTime = System.currentTimeMillis() + (long)intervalMinutes * 60L * 1000L;
        System.out.println("Next magnetic storm in " + intervalMinutes + " minutes");
    }

    private StormEffect getRandomStormEffect() {
        ArrayList<StormEffect> availableEffects = new ArrayList<StormEffect>();
        availableEffects.add(StormEffect.POLARITY_INVERT);
        availableEffects.add(StormEffect.RANDOM_POLARITY);
        availableEffects.add(StormEffect.POWER_OFF);
        availableEffects.add(StormEffect.POWER_BOOST);
        availableEffects.add(StormEffect.POWER_REDUCE);
        availableEffects.add(StormEffect.RANDOM_RADIUS);
        if (availableEffects.isEmpty()) {
            return StormEffect.POLARITY_INVERT;
        }
        return (StormEffect)((Object)availableEffects.get(this.random.nextInt(availableEffects.size())));
    }

    private void applyStormEffect(MinecraftServer server) {
        PhantomMagnetManager magnetManager = PhantomMagnetManager.get(server);
        Map<Integer, PhantomMagnetManager.PhantomMagnet> magnets = magnetManager.getMagnets();
        for (Map.Entry<Integer, PhantomMagnetManager.PhantomMagnet> entry : magnets.entrySet()) {
            PhantomMagnetManager.PhantomMagnet magnet = entry.getValue();
            MagnetBackup backup = this.magnetBackups.get(entry.getKey());
            if (backup == null) continue;
            switch (this.currentEffect.ordinal()) {
                case 0: {
                    magnet.setAttracting(!backup.attracting);
                    break;
                }
                case 1: {
                    magnet.setAttracting(this.random.nextBoolean());
                    break;
                }
                case 2: {
                    double powerReduction = 0.01 / this.stormIntensity;
                    magnet.setForceMultiplier(Math.max(0.001, powerReduction));
                    break;
                }
                case 3: {
                    double boostMultiplier = (1.5 + this.random.nextDouble() * 1.5) * this.stormIntensity;
                    double newBoostForce = backup.forceMultiplier * boostMultiplier;
                    magnet.setForceMultiplier(Math.min(newBoostForce, 10.0));
                    break;
                }
                case 4: {
                    double reduceMultiplier = (0.1 + this.random.nextDouble() * 0.4) / this.stormIntensity;
                    magnet.setForceMultiplier(backup.forceMultiplier * reduceMultiplier);
                    break;
                }
                case 5: {
                    double radiusMultiplier = 0.5 + this.random.nextDouble() * this.stormIntensity;
                    double newRadius = backup.radius * radiusMultiplier;
                    magnet.setRadius(Math.min(Math.max(newRadius, 1.0), 500.0));
                }
            }
        }
        magnetManager.method_80();
    }

    public boolean isStormActive() {
        return this.stormActive;
    }

    public StormEffect getCurrentEffect() {
        return this.currentEffect;
    }

    public long getTimeUntilNextStorm() {
        if (this.isCustomStorm) {
            return -1L;
        }
        return Math.max(0L, this.nextStormTime - System.currentTimeMillis());
    }

    public long getStormTimeRemaining() {
        return this.stormActive ? Math.max(0L, this.stormEndTime - System.currentTimeMillis()) : 0L;
    }

    public double getStormIntensity() {
        return this.stormIntensity;
    }

    public class_2487 method_75(class_2487 nbt) {
        nbt.method_10544("lastStormEndTime", this.lastStormEndTime);
        nbt.method_10544("nextStormTime", this.nextStormTime);
        nbt.method_10556("stormActive", this.stormActive);
        nbt.method_10544("stormEndTime", this.stormEndTime);
        nbt.method_10556("isCustomStorm", this.isCustomStorm);
        nbt.method_10549("stormIntensity", this.stormIntensity);
        if (this.currentEffect != null) {
            nbt.method_10582("currentEffect", this.currentEffect.name());
        }
        class_2499 backupsList = new class_2499();
        for (Map.Entry<Integer, MagnetBackup> entry : this.magnetBackups.entrySet()) {
            class_2487 backupNbt = new class_2487();
            backupNbt.method_10569("magnetId", entry.getKey().intValue());
            backupNbt.method_10566("backup", (class_2520)entry.getValue().toNbt());
            backupsList.add((Object)backupNbt);
        }
        nbt.method_10566("magnetBackups", (class_2520)backupsList);
        return nbt;
    }

    public static MagneticStormManager fromNbt(class_2487 nbt) {
        MagneticStormManager manager = new MagneticStormManager();
        manager.lastStormEndTime = nbt.method_10537("lastStormEndTime");
        manager.nextStormTime = nbt.method_10537("nextStormTime");
        manager.stormActive = nbt.method_10577("stormActive");
        manager.stormEndTime = nbt.method_10537("stormEndTime");
        manager.isCustomStorm = nbt.method_10577("isCustomStorm");
        manager.stormIntensity = nbt.method_10574("stormIntensity");
        if (nbt.method_10545("currentEffect")) {
            try {
                manager.currentEffect = StormEffect.valueOf(nbt.method_10558("currentEffect"));
            }
            catch (IllegalArgumentException e) {
                manager.currentEffect = null;
            }
        }
        if (nbt.method_10545("magnetBackups")) {
            class_2499 backupsList = nbt.method_10554("magnetBackups", 10);
            for (int i = 0; i < backupsList.size(); ++i) {
                class_2487 backupEntry = backupsList.method_10602(i);
                int magnetId = backupEntry.method_10550("magnetId");
                MagnetBackup backup = MagnetBackup.fromNbt(backupEntry.method_10562("backup"));
                manager.magnetBackups.put(magnetId, backup);
            }
        }
        if (manager.stormActive && System.currentTimeMillis() >= manager.stormEndTime) {
            manager.stormActive = false;
            manager.isCustomStorm = false;
            manager.stormIntensity = 1.0;
            manager.magnetBackups.clear();
        }
        if (manager.nextStormTime == 0L) {
            manager.scheduleNextStorm();
        }
        return manager;
    }

    public static enum StormEffect {
        POLARITY_INVERT,
        RANDOM_POLARITY,
        POWER_OFF,
        POWER_BOOST,
        POWER_REDUCE,
        RANDOM_RADIUS;

    }

    private record MagnetBackup(double radius, double forceMultiplier, boolean attracting) {
        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10549("radius", this.radius);
            nbt.method_10549("forceMultiplier", this.forceMultiplier);
            nbt.method_10556("attracting", this.attracting);
            return nbt;
        }

        public static MagnetBackup fromNbt(class_2487 nbt) {
            return new MagnetBackup(nbt.method_10574("radius"), nbt.method_10574("forceMultiplier"), nbt.method_10577("attracting"));
        }
    }
}

