/*
 * Decompiled with CFR 0.152.
 */
package net.m998.magnetblocks;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import net.m998.magnetblocks.MagnetBlockEntity;
import net.m998.magnetblocks.ModBlockEntities;
import net.m998.magnetblocks.ModItems;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class MagnetBlock
extends class_2248
implements class_2343 {
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 ATTRACTING = class_2746.method_11825((String)"attracting");
    private static final class_2350[] DIRECTIONS = class_2350.values();
    private static final Map<class_1937, Queue<PropagationTask>> propagationQueues = new WeakHashMap<class_1937, Queue<PropagationTask>>();
    private static final ThreadLocal<Set<class_2338>> updatingBlocks = ThreadLocal.withInitial(HashSet::new);

    protected MagnetBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)ATTRACTING, (Comparable)Boolean.valueOf(true)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{POWERED, ATTRACTING});
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return new class_1799((class_1935)ModItems.MAGNET_ITEM);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockEntity;
            if (!world.field_9236 && !moved) {
                class_1799 magnetStack = new class_1799((class_1935)ModItems.MAGNET_ITEM);
                class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, magnetStack);
                world.method_8649((class_1297)itemEntity);
            }
            if ((blockEntity = world.method_8321(pos)) instanceof MagnetBlockEntity) {
                world.method_8544(pos);
            }
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        if (updatingBlocks.get().contains(pos)) {
            return;
        }
        try {
            boolean currentPowered;
            boolean isRedstoneUpdate;
            updatingBlocks.get().add(pos);
            boolean bl = isRedstoneUpdate = sourceBlock.method_9564().method_26219() || world.method_8320(sourcePos).method_26204().method_9564().method_26219();
            if (!isRedstoneUpdate) {
                boolean hasLocalPower = world.method_49803(pos);
                if (hasLocalPower && !((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
                    world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)), 2);
                }
                return;
            }
            boolean powered = world.method_49803(pos);
            if (powered != (currentPowered = ((Boolean)state.method_11654((class_2769)POWERED)).booleanValue())) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
                HashSet<class_2338> visited = new HashSet<class_2338>();
                visited.add(pos);
                for (class_2350 direction : DIRECTIONS) {
                    class_2680 neighborState;
                    class_2338 neighborPos = pos.method_10093(direction);
                    if (visited.contains(neighborPos) || !((neighborState = world.method_8320(neighborPos)).method_26204() instanceof MagnetBlock)) continue;
                    MagnetBlock.addToPropagationQueue(world, new PowerChangeTask(neighborPos, powered, 0));
                }
            }
        }
        finally {
            updatingBlocks.get().remove(pos);
        }
    }

    public static void tickPropagation(class_1937 world) {
        if (world.field_9236) {
            return;
        }
        Queue<PropagationTask> queue = propagationQueues.get(world);
        if (queue != null && !queue.isEmpty()) {
            for (int i = 0; i < 32 && !queue.isEmpty(); ++i) {
                PropagationTask task = queue.poll();
                if (task == null) continue;
                task.execute(world);
                if (task.distance >= 128) continue;
                for (class_2350 direction : DIRECTIONS) {
                    class_2338 neighborPos = task.pos.method_10093(direction);
                    class_2680 neighborState = world.method_8320(neighborPos);
                    if (!(neighborState.method_26204() instanceof MagnetBlock)) continue;
                    if (task instanceof PowerChangeTask) {
                        PowerChangeTask powerTask = (PowerChangeTask)task;
                        if (!MagnetBlock.shouldPropagatePower(world, neighborPos, neighborState, powerTask.powered)) continue;
                        MagnetBlock.addToPropagationQueue(world, new PowerChangeTask(neighborPos, powerTask.powered, task.distance + 1));
                        continue;
                    }
                    if (!(task instanceof PolarityChangeTask)) continue;
                    PolarityChangeTask polarityTask = (PolarityChangeTask)task;
                    if (!MagnetBlock.shouldPropagatePolarity(neighborState, polarityTask.attracting)) continue;
                    MagnetBlock.addToPropagationQueue(world, new PolarityChangeTask(neighborPos, polarityTask.attracting, task.distance + 1));
                }
            }
            if (queue.isEmpty()) {
                propagationQueues.remove(world);
            }
        }
    }

    private static boolean shouldPropagatePower(class_1937 world, class_2338 pos, class_2680 state, boolean newPowered) {
        boolean hasLocalPower = world.method_49803(pos);
        if (hasLocalPower && !newPowered) {
            return false;
        }
        return (Boolean)state.method_11654((class_2769)POWERED) != newPowered;
    }

    private static boolean shouldPropagatePolarity(class_2680 state, boolean newAttracting) {
        return (Boolean)state.method_11654((class_2769)ATTRACTING) != newAttracting;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_7909() == class_1802.field_8475) {
            if (!world.field_9236) {
                boolean currentPolarity = (Boolean)state.method_11654((class_2769)ATTRACTING);
                boolean newPolarity = !currentPolarity;
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)ATTRACTING, (Comparable)Boolean.valueOf(newPolarity)), 2);
                world.method_31595(pos, state);
                MagnetBlock.addToPropagationQueue(world, new PolarityChangeTask(pos, newPolarity, 0));
                if (!player.method_31549().field_7477) {
                    itemStack.method_7956(10, (class_1309)player, playerEntity -> playerEntity.method_20236(hand));
                }
                world.method_8396(null, pos, class_3417.field_23116, class_3419.field_15245, 1.0f, 1.0f);
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    serverWorld.method_14199((class_2394)class_2398.field_29644, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, 10, 0.3, 0.3, 0.3, 0.1);
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private static void addToPropagationQueue(class_1937 world, PropagationTask task) {
        Queue queue = propagationQueues.computeIfAbsent(world, k -> new LinkedList());
        boolean alreadyExists = queue.stream().anyMatch(t -> t.pos.equals((Object)task.pos) && t.getClass() == task.getClass());
        if (!alreadyExists) {
            queue.add(task);
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MagnetBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? null : MagnetBlock.checkType(type, ModBlockEntities.MAGNET_BLOCK_ENTITY, (world1, pos, state1, blockEntity) -> MagnetBlockEntity.tick(world1, pos, state1));
    }

    @Nullable
    protected static <E extends class_2586, A extends class_2586> class_5558<A> checkType(class_2591<A> givenType, class_2591<E> expectedType, class_5558<? super E> ticker) {
        return expectedType == givenType ? ticker : null;
    }

    private static class PowerChangeTask
    extends PropagationTask {
        private final boolean powered;

        public PowerChangeTask(class_2338 pos, boolean powered, int distance) {
            super(pos, distance);
            this.powered = powered;
        }

        @Override
        public void execute(class_1937 world) {
            class_2680 state = world.method_8320(this.pos);
            if (state.method_26204() instanceof MagnetBlock) {
                boolean hasLocalPower = world.method_49803(this.pos);
                if (hasLocalPower) {
                    if (!((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
                        world.method_8652(this.pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)), 2);
                    }
                    return;
                }
                if ((Boolean)state.method_11654((class_2769)POWERED) != this.powered) {
                    world.method_8652(this.pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(this.powered)), 2);
                }
            }
        }
    }

    private static abstract class PropagationTask {
        public final class_2338 pos;
        public final int distance;

        public PropagationTask(class_2338 pos, int distance) {
            this.pos = pos;
            this.distance = distance;
        }

        public abstract void execute(class_1937 var1);
    }

    private static class PolarityChangeTask
    extends PropagationTask {
        private final boolean attracting;

        public PolarityChangeTask(class_2338 pos, boolean attracting, int distance) {
            super(pos, distance);
            this.attracting = attracting;
        }

        @Override
        public void execute(class_1937 world) {
            class_2680 state = world.method_8320(this.pos);
            if (state.method_26204() instanceof MagnetBlock && (Boolean)state.method_11654((class_2769)ATTRACTING) != this.attracting) {
                world.method_8652(this.pos, (class_2680)state.method_11657((class_2769)ATTRACTING, (Comparable)Boolean.valueOf(this.attracting)), 2);
                world.method_31595(this.pos, state);
            }
        }
    }
}

