/*
 * Decompiled with CFR 0.152.
 */
package net.m998.magnetblocks;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class MagnetWhitelistManager
extends class_18 {
    private static final String DATA_NAME = "magnetblocks_whitelist";
    private final Map<UUID, WhitelistEntry> whitelist = new HashMap<UUID, WhitelistEntry>();

    public static MagnetWhitelistManager get(MinecraftServer server) {
        class_3218 world = server.method_30002();
        return (MagnetWhitelistManager)world.method_17983().method_17924(MagnetWhitelistManager::fromNbt, MagnetWhitelistManager::new, DATA_NAME);
    }

    public void addPlayer(UUID playerUUID, double strength) {
        this.whitelist.put(playerUUID, new WhitelistEntry(playerUUID, strength));
        this.method_80();
    }

    public boolean removePlayer(UUID playerUUID) {
        boolean removed;
        boolean bl = removed = this.whitelist.remove(playerUUID) != null;
        if (removed) {
            this.method_80();
        }
        return removed;
    }

    public Double getPlayerStrength(UUID playerUUID) {
        WhitelistEntry entry = this.whitelist.get(playerUUID);
        return entry != null ? Double.valueOf(entry.strength) : null;
    }

    public Map<UUID, WhitelistEntry> getWhitelist() {
        return this.whitelist;
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 whitelistList = new class_2499();
        for (WhitelistEntry entry : this.whitelist.values()) {
            whitelistList.add((Object)entry.toNbt());
        }
        nbt.method_10566("whitelist", (class_2520)whitelistList);
        return nbt;
    }

    public static MagnetWhitelistManager fromNbt(class_2487 nbt) {
        MagnetWhitelistManager manager = new MagnetWhitelistManager();
        if (nbt.method_10545("whitelist")) {
            class_2499 whitelistList = nbt.method_10554("whitelist", 10);
            for (int i = 0; i < whitelistList.size(); ++i) {
                WhitelistEntry entry = WhitelistEntry.fromNbt(whitelistList.method_10602(i));
                manager.whitelist.put(entry.playerUUID, entry);
            }
        }
        return manager;
    }

    public static class WhitelistEntry {
        private final UUID playerUUID;
        private final double strength;

        public WhitelistEntry(UUID playerUUID, double strength) {
            this.playerUUID = playerUUID;
            this.strength = Math.max(0.1, Math.min(strength, 10.0));
        }

        public double getStrength() {
            return this.strength;
        }

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_25927("playerUUID", this.playerUUID);
            nbt.method_10549("strength", this.strength);
            return nbt;
        }

        public static WhitelistEntry fromNbt(class_2487 nbt) {
            return new WhitelistEntry(nbt.method_25926("playerUUID"), nbt.method_10574("strength"));
        }
    }
}

