/*
 * Decompiled with CFR 0.152.
 */
package net.m998.magnetblocks;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import net.m998.magnetblocks.MagnetBlockEntity;
import net.m998.magnetblocks.ModBlockEntities;
import net.m998.magnetblocks.ModItems;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_167;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2770;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MagnetBlock
extends class_2248
implements class_2343 {
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 ATTRACTING = class_2746.method_11825((String)"attracting");
    public static final class_2746 OVERHEATED = class_2746.method_11825((String)"overheated");
    public static final class_2746 SUPERCONDUCTING = class_2746.method_11825((String)"superconducting");
    public static final class_2758 TEMPERATURE = class_2758.method_11867((String)"temperature", (int)0, (int)20);
    private static final class_2350[] DIRECTIONS = class_2350.values();
    private static final Map<class_1937, Queue<PropagationTask>> propagationQueues = new WeakHashMap<class_1937, Queue<PropagationTask>>();
    private static final ThreadLocal<Set<class_2338>> updatingBlocks = ThreadLocal.withInitial(HashSet::new);
    private static final Map<class_2248, Integer> TEMPERATURE_EFFECTS = new HashMap<class_2248, Integer>();
    private static final Set<class_2248> MELTABLE_ICE_BLOCKS;

    protected MagnetBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)ATTRACTING, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)OVERHEATED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SUPERCONDUCTING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)TEMPERATURE, (Comparable)Integer.valueOf(10)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{POWERED, ATTRACTING, OVERHEATED, SUPERCONDUCTING, TEMPERATURE});
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return new class_1799((class_1935)ModItems.MAGNET_ITEM);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockEntity;
            if (!world.field_9236 && !moved) {
                this.stopBeaconSoundForNearbyPlayers((class_3218)world, pos);
            }
            if ((blockEntity = world.method_8321(pos)) instanceof MagnetBlockEntity) {
                world.method_8544(pos);
            }
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    private void stopBeaconSoundForNearbyPlayers(class_3218 world, class_2338 pos) {
        List players = world.method_18766(player -> player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) <= 256.0);
        for (class_3222 player2 : players) {
            player2.field_13987.method_14364((class_2596)new class_2770(class_3417.field_15045.method_14833(), class_3419.field_15245));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        if (updatingBlocks.get().contains(pos)) {
            return;
        }
        try {
            boolean currentPowered;
            boolean isRedstoneUpdate;
            updatingBlocks.get().add(pos);
            this.updateTemperature(world, pos, state);
            boolean bl = isRedstoneUpdate = sourceBlock.method_9564().method_26219() || world.method_8320(sourcePos).method_26204().method_9564().method_26219();
            if (!isRedstoneUpdate) {
                boolean hasLocalPower = world.method_49803(pos);
                if (hasLocalPower && !((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
                    world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)), 2);
                }
                return;
            }
            boolean powered = world.method_49803(pos);
            if (powered != (currentPowered = ((Boolean)state.method_11654((class_2769)POWERED)).booleanValue())) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
                if (!powered) {
                    world.method_8396(null, pos, class_3417.field_15045, class_3419.field_15245, 0.5f, 0.8f);
                } else {
                    this.stopBeaconSoundForNearbyPlayers((class_3218)world, pos);
                }
                HashSet<class_2338> visited = new HashSet<class_2338>();
                visited.add(pos);
                for (class_2350 direction : DIRECTIONS) {
                    class_2680 neighborState;
                    class_2338 neighborPos = pos.method_10093(direction);
                    if (visited.contains(neighborPos) || !((neighborState = world.method_8320(neighborPos)).method_26204() instanceof MagnetBlock)) continue;
                    MagnetBlock.addToPropagationQueue(world, new PowerChangeTask(neighborPos, powered, 0));
                }
            }
        }
        finally {
            updatingBlocks.get().remove(pos);
        }
    }

    private void updateTemperature(class_1937 world, class_2338 pos, class_2680 state) {
        int currentTemp;
        if (world.field_9236) {
            return;
        }
        int totalTemperatureEffect = 0;
        boolean foundExtremeCold = false;
        for (class_2350 direction : class_2350.values()) {
            int meltChance;
            class_2338 neighborPos = pos.method_10093(direction);
            class_2680 neighborState = world.method_8320(neighborPos);
            class_2248 neighborBlock = neighborState.method_26204();
            if (!TEMPERATURE_EFFECTS.containsKey(neighborBlock)) continue;
            int effect = TEMPERATURE_EFFECTS.get(neighborBlock);
            totalTemperatureEffect += effect;
            if (effect <= -4) {
                foundExtremeCold = true;
            }
            if (world.field_9229.method_43048(8) == 0) {
                if (effect > 0) {
                    world.method_8406((class_2394)class_2398.field_11239, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, 0.0, 0.0, 0.0);
                } else if (effect < 0) {
                    world.method_8406((class_2394)class_2398.field_28013, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, 0.0, 0.0, 0.0);
                }
            }
            if (!MELTABLE_ICE_BLOCKS.contains(neighborBlock) || world.field_9229.method_43048(meltChance = this.getMeltChance(neighborBlock)) != 0) continue;
            if (neighborBlock == class_2246.field_10477) {
                world.method_22352(neighborPos, false);
            } else {
                world.method_8501(neighborPos, class_2246.field_10382.method_9564());
            }
            world.method_8396(null, neighborPos, class_3417.field_15081, class_3419.field_15245, 0.5f, 1.0f);
        }
        int baseTemperature = 10;
        int newTemp = Math.max(0, Math.min(20, baseTemperature + totalTemperatureEffect));
        if (newTemp != (currentTemp = ((Integer)state.method_11654((class_2769)TEMPERATURE)).intValue())) {
            class_2680 newState = (class_2680)state.method_11657((class_2769)TEMPERATURE, (Comparable)Integer.valueOf(newTemp));
            if (newTemp >= 18 && !((Boolean)state.method_11654((class_2769)OVERHEATED)).booleanValue()) {
                newState = (class_2680)newState.method_11657((class_2769)OVERHEATED, (Comparable)Boolean.valueOf(true));
                world.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 0.8f);
                if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
                    newState = (class_2680)newState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false));
                }
            } else if (newTemp < 18 && ((Boolean)state.method_11654((class_2769)OVERHEATED)).booleanValue()) {
                newState = (class_2680)newState.method_11657((class_2769)OVERHEATED, (Comparable)Boolean.valueOf(false));
            }
            if (foundExtremeCold && newTemp == 0 && !((Boolean)state.method_11654((class_2769)SUPERCONDUCTING)).booleanValue()) {
                this.grantSuperconductivityAchievement(world, pos);
                newState = (class_2680)newState.method_11657((class_2769)SUPERCONDUCTING, (Comparable)Boolean.valueOf(true));
            } else if (newTemp != 0 && ((Boolean)state.method_11654((class_2769)SUPERCONDUCTING)).booleanValue()) {
                newState = (class_2680)newState.method_11657((class_2769)SUPERCONDUCTING, (Comparable)Boolean.valueOf(false));
            }
            world.method_8652(pos, newState, 3);
        } else {
            boolean shouldBeSuperconducting = foundExtremeCold && currentTemp == 0;
            boolean currentlySuperconducting = (Boolean)state.method_11654((class_2769)SUPERCONDUCTING);
            if (shouldBeSuperconducting && !currentlySuperconducting) {
                this.grantSuperconductivityAchievement(world, pos);
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)SUPERCONDUCTING, (Comparable)Boolean.valueOf(true)), 3);
            } else if (!shouldBeSuperconducting && currentlySuperconducting) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)SUPERCONDUCTING, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    private int getMeltChance(class_2248 block) {
        if (block == class_2246.field_10477) {
            return 36000;
        }
        if (block == class_2246.field_10295) {
            return 54000;
        }
        if (block == class_2246.field_10225) {
            return 72000;
        }
        if (block == class_2246.field_10384) {
            return 108000;
        }
        return 200;
    }

    private void grantSuperconductivityAchievement(class_1937 world, class_2338 pos) {
        if (world.field_9236) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        List players = serverWorld.method_18766(player -> player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) <= 100.0);
        for (class_3222 player2 : players) {
            class_167 progress;
            class_161 advancement = serverWorld.method_8503().method_3851().method_12896(new class_2960("magnetblocks", "superconductivity"));
            if (advancement == null || (progress = player2.method_14236().method_12882(advancement)).method_740()) continue;
            for (String criterion : progress.method_731()) {
                player2.method_14236().method_12878(advancement, criterion);
            }
        }
    }

    public static void tickPropagation(class_1937 world) {
        if (world.field_9236) {
            return;
        }
        Queue<PropagationTask> queue = propagationQueues.get(world);
        if (queue != null && !queue.isEmpty()) {
            for (int i = 0; i < 32 && !queue.isEmpty(); ++i) {
                PropagationTask task = queue.poll();
                if (task == null) continue;
                task.execute(world);
                if (task.distance >= 128) continue;
                for (class_2350 direction : DIRECTIONS) {
                    class_2338 neighborPos = task.pos.method_10093(direction);
                    class_2680 neighborState = world.method_8320(neighborPos);
                    if (!(neighborState.method_26204() instanceof MagnetBlock)) continue;
                    if (task instanceof PowerChangeTask) {
                        PowerChangeTask powerTask = (PowerChangeTask)task;
                        if (!MagnetBlock.shouldPropagatePower(world, neighborPos, neighborState, powerTask.powered)) continue;
                        MagnetBlock.addToPropagationQueue(world, new PowerChangeTask(neighborPos, powerTask.powered, task.distance + 1));
                        continue;
                    }
                    if (!(task instanceof PolarityChangeTask)) continue;
                    PolarityChangeTask polarityTask = (PolarityChangeTask)task;
                    if (!MagnetBlock.shouldPropagatePolarity(neighborState, polarityTask.attracting)) continue;
                    MagnetBlock.addToPropagationQueue(world, new PolarityChangeTask(neighborPos, polarityTask.attracting, task.distance + 1));
                }
            }
            if (queue.isEmpty()) {
                propagationQueues.remove(world);
            }
        }
    }

    private static boolean shouldPropagatePower(class_1937 world, class_2338 pos, class_2680 state, boolean newPowered) {
        boolean hasLocalPower = world.method_49803(pos);
        if (hasLocalPower && !newPowered) {
            return false;
        }
        return (Boolean)state.method_11654((class_2769)POWERED) != newPowered;
    }

    private static boolean shouldPropagatePolarity(class_2680 state, boolean newAttracting) {
        return (Boolean)state.method_11654((class_2769)ATTRACTING) != newAttracting;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_7909() == class_1802.field_8475) {
            if (!world.field_9236) {
                boolean currentPolarity = (Boolean)state.method_11654((class_2769)ATTRACTING);
                boolean newPolarity = !currentPolarity;
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)ATTRACTING, (Comparable)Boolean.valueOf(newPolarity)), 2);
                world.method_31595(pos, state);
                MagnetBlock.addToPropagationQueue(world, new PolarityChangeTask(pos, newPolarity, 0));
                if (!player.method_31549().field_7477) {
                    itemStack.method_7956(10, (class_1309)player, playerEntity -> playerEntity.method_20236(hand));
                }
                world.method_8396(null, pos, class_3417.field_23116, class_3419.field_15245, 1.0f, 1.0f);
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    serverWorld.method_14199((class_2394)class_2398.field_29644, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, 10, 0.3, 0.3, 0.3, 0.1);
                }
            }
            return class_1269.field_5812;
        }
        if (itemStack.method_7909() == class_1802.field_8600 && player.method_5715()) {
            if (!world.field_9236) {
                int temp = (Integer)state.method_11654((class_2769)TEMPERATURE);
                boolean overheated = (Boolean)state.method_11654((class_2769)OVERHEATED);
                boolean superconducting = (Boolean)state.method_11654((class_2769)SUPERCONDUCTING);
                String tempStatus = MagnetBlock.getTemperatureString(temp);
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a76Magnet Temperature: " + temp + "/20 (" + tempStatus + ") | Overheated: " + overheated + " | Superconducting: " + superconducting)), false);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @NotNull
    private static String getTemperatureString(int temp) {
        if (temp == 0) {
            return "Absolute Zero (Superconducting)";
        }
        if (temp <= 2) {
            return "Extreme Cold";
        }
        if (temp <= 5) {
            return "Very Cold";
        }
        if (temp <= 8) {
            return "Cold";
        }
        if (temp <= 12) {
            return "Normal";
        }
        if (temp <= 15) {
            return "Warm";
        }
        if (temp <= 17) {
            return "Very Hot";
        }
        return "Extreme Heat (Overheated)";
    }

    private static void addToPropagationQueue(class_1937 world, PropagationTask task) {
        Queue queue = propagationQueues.computeIfAbsent(world, k -> new LinkedList());
        boolean alreadyExists = queue.stream().anyMatch(t -> t.pos.equals((Object)task.pos) && t.getClass() == task.getClass());
        if (!alreadyExists) {
            queue.add(task);
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MagnetBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? null : MagnetBlock.checkType(type, ModBlockEntities.MAGNET_BLOCK_ENTITY, (world1, pos, state1, blockEntity) -> MagnetBlockEntity.tick(world1, pos, state1));
    }

    @Nullable
    protected static <E extends class_2586, A extends class_2586> class_5558<A> checkType(class_2591<A> givenType, class_2591<E> expectedType, class_5558<? super E> ticker) {
        return expectedType == givenType ? ticker : null;
    }

    static {
        TEMPERATURE_EFFECTS.put(class_2246.field_10164, 8);
        TEMPERATURE_EFFECTS.put(class_2246.field_10036, 6);
        TEMPERATURE_EFFECTS.put(class_2246.field_10092, 5);
        TEMPERATURE_EFFECTS.put(class_2246.field_17350, 4);
        TEMPERATURE_EFFECTS.put(class_2246.field_23860, 3);
        TEMPERATURE_EFFECTS.put(class_2246.field_10181, 4);
        TEMPERATURE_EFFECTS.put(class_2246.field_16333, 5);
        TEMPERATURE_EFFECTS.put(class_2246.field_16334, 4);
        TEMPERATURE_EFFECTS.put(class_2246.field_10336, 2);
        TEMPERATURE_EFFECTS.put(class_2246.field_22092, 1);
        TEMPERATURE_EFFECTS.put(class_2246.field_16541, 1);
        TEMPERATURE_EFFECTS.put(class_2246.field_22110, 1);
        TEMPERATURE_EFFECTS.put(class_2246.field_10384, -6);
        TEMPERATURE_EFFECTS.put(class_2246.field_10225, -4);
        TEMPERATURE_EFFECTS.put(class_2246.field_10295, -3);
        TEMPERATURE_EFFECTS.put(class_2246.field_10491, -2);
        TEMPERATURE_EFFECTS.put(class_2246.field_27879, -2);
        TEMPERATURE_EFFECTS.put(class_2246.field_10477, -1);
        MELTABLE_ICE_BLOCKS = Set.of(class_2246.field_10295, class_2246.field_10225, class_2246.field_10384, class_2246.field_10477);
    }

    private static class PowerChangeTask
    extends PropagationTask {
        private final boolean powered;

        public PowerChangeTask(class_2338 pos, boolean powered, int distance) {
            super(pos, distance);
            this.powered = powered;
        }

        @Override
        public void execute(class_1937 world) {
            class_2680 state = world.method_8320(this.pos);
            if (state.method_26204() instanceof MagnetBlock) {
                boolean hasLocalPower = world.method_49803(this.pos);
                if (hasLocalPower) {
                    if (!((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
                        world.method_8652(this.pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)), 2);
                    }
                    return;
                }
                if ((Boolean)state.method_11654((class_2769)POWERED) != this.powered) {
                    world.method_8652(this.pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(this.powered)), 2);
                }
            }
        }
    }

    private static abstract class PropagationTask {
        public final class_2338 pos;
        public final int distance;

        public PropagationTask(class_2338 pos, int distance) {
            this.pos = pos;
            this.distance = distance;
        }

        public abstract void execute(class_1937 var1);
    }

    private static class PolarityChangeTask
    extends PropagationTask {
        private final boolean attracting;

        public PolarityChangeTask(class_2338 pos, boolean attracting, int distance) {
            super(pos, distance);
            this.attracting = attracting;
        }

        @Override
        public void execute(class_1937 world) {
            class_2680 state = world.method_8320(this.pos);
            if (state.method_26204() instanceof MagnetBlock && (Boolean)state.method_11654((class_2769)ATTRACTING) != this.attracting) {
                world.method_8652(this.pos, (class_2680)state.method_11657((class_2769)ATTRACTING, (Comparable)Boolean.valueOf(this.attracting)), 2);
                world.method_31595(this.pos, state);
            }
        }
    }
}

