/*
 * Decompiled with CFR 0.152.
 */
package net.m998.magnetblocks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.m998.magnetblocks.MagnetBlock;
import net.m998.magnetblocks.MagnetWhitelistManager;
import net.m998.magnetblocks.ModBlockEntities;
import net.m998.magnetblocks.ModItems;
import net.m998.magnetblocks.PhantomMagnetManager;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1439;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1560;
import net.minecraft.class_1657;
import net.minecraft.class_1684;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;

public class MagnetBlockEntity
extends class_2586 {
    private static final double RANGE = 40.0;
    private static final double FORCE = 0.01;
    private static final double PHANTOM_BASE_FORCE = 0.04;
    private static final Map<class_1792, Double> ITEM_STRENGTH_MAP = new HashMap<class_1792, Double>();

    public MagnetBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.MAGNET_BLOCK_ENTITY, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.field_9236) {
            return;
        }
        if (!((Boolean)state.method_11654((class_2769)MagnetBlock.POWERED)).booleanValue()) {
            MagnetBlockEntity.processMagnetBlock(world, pos, state);
        }
    }

    private static void processMagnetBlock(class_1937 world, class_2338 pos, class_2680 state) {
        if (((Boolean)state.method_11654((class_2769)MagnetBlock.OVERHEATED)).booleanValue()) {
            if (world.method_8510() % 10L == 0L) {
                world.method_8406((class_2394)class_2398.field_11239, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, 0.0, 0.1, 0.0);
                world.method_8406((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, 0.0, 0.1, 0.0);
            }
            return;
        }
        class_243 blockCenter = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        boolean isAttracting = (Boolean)state.method_11654((class_2769)MagnetBlock.ATTRACTING);
        double temperatureMultiplier = MagnetBlockEntity.calculateTemperatureMultiplier(state);
        double adjustedForce = 0.01 * temperatureMultiplier;
        double adjustedRange = 40.0 * temperatureMultiplier;
        if (world.method_8510() % 20L == 0L) {
            MagnetBlockEntity.playMagnetSound(world, pos, state);
        }
        MagnetBlockEntity.applyMagneticForceToArea(world, blockCenter, adjustedRange, adjustedForce, isAttracting, false);
    }

    private static double calculateTemperatureMultiplier(class_2680 state) {
        int temperature = (Integer)state.method_11654((class_2769)MagnetBlock.TEMPERATURE);
        double multiplier = 1.0;
        if (temperature < 10) {
            double coolingBonus = (double)(10 - temperature) * 0.1;
            multiplier = 1.0 + coolingBonus;
        } else if (temperature > 10) {
            double heatingPenalty = (double)(temperature - 10) * 0.08;
            multiplier = 1.0 - heatingPenalty;
        }
        if (((Boolean)state.method_11654((class_2769)MagnetBlock.SUPERCONDUCTING)).booleanValue()) {
            multiplier *= 2.0;
        }
        return multiplier;
    }

    private static void playMagnetSound(class_1937 world, class_2338 pos, class_2680 state) {
        float volume = 0.3f;
        float pitch = 0.9f;
        if (((Boolean)state.method_11654((class_2769)MagnetBlock.SUPERCONDUCTING)).booleanValue()) {
            pitch = 1.4f;
            volume = 0.5f;
        } else {
            int temperature = (Integer)state.method_11654((class_2769)MagnetBlock.TEMPERATURE);
            if (temperature < 10) {
                pitch = 1.1f + (float)(10 - temperature) * 0.05f;
            } else if (temperature > 10) {
                pitch = 0.8f - (float)(temperature - 10) * 0.03f;
            }
        }
        world.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_15045, class_3419.field_15245, volume, pitch);
    }

    public static void processAllPhantomMagnets(class_1937 world) {
        if (world.field_9236) {
            return;
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            PhantomMagnetManager manager = PhantomMagnetManager.get(serverWorld.method_8503());
            Map<Integer, PhantomMagnetManager.PhantomMagnet> magnets = manager.getMagnets();
            for (Map.Entry<Integer, PhantomMagnetManager.PhantomMagnet> entry : magnets.entrySet()) {
                PhantomMagnetManager.PhantomMagnet magnet = entry.getValue();
                class_243 magnetCenter = new class_243((double)magnet.getPos().method_10263() + 0.5, (double)magnet.getPos().method_10264() + 0.5, (double)magnet.getPos().method_10260() + 0.5);
                double force = 0.04 * magnet.getForceMultiplier();
                if (world.method_8510() % 20L == 0L) {
                    world.method_43128(null, magnetCenter.field_1352, magnetCenter.field_1351, magnetCenter.field_1350, class_3417.field_15045, class_3419.field_15245, 0.4f, 0.7f);
                }
                MagnetBlockEntity.applyMagneticForceToArea(world, magnetCenter, magnet.getRadius(), force, magnet.isAttracting(), true);
            }
        }
    }

    private static void applyMagneticForceToArea(class_1937 world, class_243 center, double range, double baseForce, boolean isAttracting, boolean isPhantom) {
        class_238 area = new class_238(center.field_1352 - range, center.field_1351 - range, center.field_1350 - range, center.field_1352 + range, center.field_1351 + range, center.field_1350 + range);
        List entities = world.method_18467(class_1297.class, area);
        for (class_1297 entity : entities) {
            class_243 entityPos;
            double distance;
            double strength = MagnetBlockEntity.getEntityStrength(entity);
            if (strength <= 0.0 || !((distance = (entityPos = entity.method_19538()).method_1022(center)) <= range) || !(distance > 1.5)) continue;
            class_243 direction = isAttracting ? center.method_1020(entityPos).method_1029() : entityPos.method_1020(center).method_1029();
            double forceMultiplier = 1.0 - distance / range;
            double strengthMultiplier = Math.max(0.01, Math.min(strength, 5.0));
            class_243 velocity = direction.method_1021(baseForce * forceMultiplier * strengthMultiplier);
            entity.method_5762(velocity.field_1352, velocity.field_1351, velocity.field_1350);
            entity.field_6037 = true;
            if (world.field_9229.method_43048(isPhantom ? 3 : 10) != 0) continue;
            MagnetBlockEntity.spawnMagneticParticles(world, entityPos, entity.method_17682(), velocity, isAttracting, isPhantom);
        }
    }

    private static void spawnMagneticParticles(class_1937 world, class_243 pos, float height, class_243 velocity, boolean isAttracting, boolean isPhantom) {
        if (isAttracting) {
            if (isPhantom) {
                world.method_8406((class_2394)class_2398.field_22246, pos.field_1352, pos.field_1351 + (double)(height / 2.0f), pos.field_1350, velocity.field_1352 * 0.1, velocity.field_1351 * 0.1, velocity.field_1350 * 0.1);
            } else {
                world.method_8406((class_2394)class_2398.field_29644, pos.field_1352, pos.field_1351 + (double)(height / 2.0f), pos.field_1350, velocity.field_1352 * 0.1, velocity.field_1351 * 0.1, velocity.field_1350 * 0.1);
            }
        } else if (isPhantom) {
            world.method_8406((class_2394)class_2398.field_23190, pos.field_1352, pos.field_1351 + (double)(height / 2.0f), pos.field_1350, velocity.field_1352 * 0.1, velocity.field_1351 * 0.1, velocity.field_1350 * 0.1);
        } else {
            world.method_8406((class_2394)class_2398.field_22246, pos.field_1352, pos.field_1351 + (double)(height / 2.0f), pos.field_1350, velocity.field_1352 * 0.1, velocity.field_1351 * 0.1, velocity.field_1350 * 0.1);
        }
    }

    private static double getEntityStrength(class_1297 entity) {
        class_1309 living;
        double equipmentStrength;
        if (entity instanceof class_1657) {
            MagnetWhitelistManager whitelistManager;
            Double whitelistStrength;
            class_1657 player = (class_1657)entity;
            if (player.method_7337() || player.method_7325()) {
                return 0.0;
            }
            MinecraftServer server = entity.method_37908().method_8503();
            if (server != null && (whitelistStrength = (whitelistManager = MagnetWhitelistManager.get(server)).getPlayerStrength(player.method_5667())) != null) {
                return whitelistStrength;
            }
            return MagnetBlockEntity.getPlayerStrength(player);
        }
        if (entity instanceof class_1439) {
            return 2.5;
        }
        if (entity instanceof class_1560) {
            return 0.5;
        }
        if (entity instanceof class_1309 && (equipmentStrength = MagnetBlockEntity.getMobEquipmentStrength(living = (class_1309)entity)) > 0.0) {
            return equipmentStrength;
        }
        if (entity instanceof class_1684) {
            return 2.5;
        }
        if (entity instanceof class_1540) {
            class_1540 fallingBlock = (class_1540)entity;
            return MagnetBlockEntity.getFallingBlockStrength(fallingBlock);
        }
        if (entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            return MagnetBlockEntity.getItemStrength(itemEntity.method_6983());
        }
        return 0.0;
    }

    private static double getFallingBlockStrength(class_1540 fallingBlock) {
        class_2680 blockState = fallingBlock.method_6962();
        String blockName = blockState.method_26204().method_9539().toLowerCase();
        return blockName.contains("anvil") ? 3.0 : 0.0;
    }

    private static double getMobEquipmentStrength(class_1309 mob) {
        double totalStrength = 0.0;
        int magneticItems = 0;
        for (class_1799 stack : mob.method_5661()) {
            double strength = MagnetBlockEntity.getItemStrength(stack);
            if (!(strength > 0.0)) continue;
            totalStrength += strength;
            ++magneticItems;
        }
        class_1799 mainHand = mob.method_6047();
        double mainHandStrength = MagnetBlockEntity.getItemStrength(mainHand);
        if (mainHandStrength > 0.0) {
            totalStrength += mainHandStrength;
            ++magneticItems;
        }
        return magneticItems > 0 ? totalStrength / (double)magneticItems : 0.0;
    }

    private static double getPlayerStrength(class_1657 player) {
        double armorStrength = MagnetBlockEntity.getArmorStrength(player);
        double heldItemStrength = MagnetBlockEntity.getHeldItemStrength(player);
        return Math.max(armorStrength, heldItemStrength);
    }

    private static double getArmorStrength(class_1657 player) {
        double totalStrength = 0.0;
        int armorPieces = 0;
        for (class_1799 armorStack : player.method_5661()) {
            double pieceStrength = MagnetBlockEntity.getItemStrength(armorStack);
            if (!(pieceStrength > 0.0)) continue;
            totalStrength += pieceStrength;
            ++armorPieces;
        }
        return armorPieces >= 2 ? totalStrength / (double)armorPieces : 0.0;
    }

    private static double getHeldItemStrength(class_1657 player) {
        return Math.max(MagnetBlockEntity.getItemStrength(player.method_6047()), MagnetBlockEntity.getItemStrength(player.method_6079()));
    }

    private static double getItemStrength(class_1799 stack) {
        if (stack.method_7960()) {
            return 0.0;
        }
        if (stack.method_7909() == ModItems.MAGNET_ITEM) {
            return 4.5;
        }
        Double strength = ITEM_STRENGTH_MAP.get(stack.method_7909());
        return strength != null ? strength : 0.0;
    }

    private static void initializeItemStrengthMap() {
        ITEM_STRENGTH_MAP.put(class_1802.field_22018, 1.2);
        ITEM_STRENGTH_MAP.put(class_1802.field_22020, 0.9);
        ITEM_STRENGTH_MAP.put(class_1802.field_22022, 1.08);
        ITEM_STRENGTH_MAP.put(class_1802.field_22025, 1.08);
        ITEM_STRENGTH_MAP.put(class_1802.field_22024, 1.08);
        ITEM_STRENGTH_MAP.put(class_1802.field_22023, 0.9);
        ITEM_STRENGTH_MAP.put(class_1802.field_22026, 0.9);
        ITEM_STRENGTH_MAP.put(class_1802.field_22027, 0.9);
        ITEM_STRENGTH_MAP.put(class_1802.field_22028, 1.2);
        ITEM_STRENGTH_MAP.put(class_1802.field_22029, 1.08);
        ITEM_STRENGTH_MAP.put(class_1802.field_22030, 0.9);
        ITEM_STRENGTH_MAP.put(class_1802.field_22021, 0.72);
        ITEM_STRENGTH_MAP.put(class_1802.field_22019, 0.6);
        ITEM_STRENGTH_MAP.put(class_1802.field_8773, 1.8);
        ITEM_STRENGTH_MAP.put(class_1802.field_33505, 1.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8594, 1.2);
        ITEM_STRENGTH_MAP.put(class_1802.field_8241, 1.08);
        ITEM_STRENGTH_MAP.put(class_1802.field_8076, 0.9);
        ITEM_STRENGTH_MAP.put(class_1802.field_23983, 0.72);
        ITEM_STRENGTH_MAP.put(class_1802.field_8239, 1.68);
        ITEM_STRENGTH_MAP.put(class_1802.field_8638, 1.2);
        ITEM_STRENGTH_MAP.put(class_1802.field_8371, 1.08);
        ITEM_STRENGTH_MAP.put(class_1802.field_8475, 1.08);
        ITEM_STRENGTH_MAP.put(class_1802.field_8403, 1.08);
        ITEM_STRENGTH_MAP.put(class_1802.field_8699, 0.9);
        ITEM_STRENGTH_MAP.put(class_1802.field_8609, 0.9);
        ITEM_STRENGTH_MAP.put(class_1802.field_8868, 0.72);
        ITEM_STRENGTH_MAP.put(class_1802.field_8884, 0.48);
        ITEM_STRENGTH_MAP.put(class_1802.field_8743, 0.9);
        ITEM_STRENGTH_MAP.put(class_1802.field_8523, 1.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8396, 1.2);
        ITEM_STRENGTH_MAP.put(class_1802.field_8660, 0.9);
        ITEM_STRENGTH_MAP.put(class_1802.field_8578, 1.2);
        ITEM_STRENGTH_MAP.put(class_1802.field_8620, 0.6);
        ITEM_STRENGTH_MAP.put(class_1802.field_33400, 0.48);
        ITEM_STRENGTH_MAP.put(class_1802.field_8675, 0.18);
        ITEM_STRENGTH_MAP.put(class_1802.field_8599, 0.48);
        ITEM_STRENGTH_MAP.put(class_1802.field_29020, 0.48);
        ITEM_STRENGTH_MAP.put(class_1802.field_8782, 1.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8750, 1.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_8427, 0.7);
        ITEM_STRENGTH_MAP.put(class_1802.field_8550, 0.6);
        ITEM_STRENGTH_MAP.put(class_1802.field_8045, 1.5);
        ITEM_STRENGTH_MAP.put(class_1802.field_8129, 0.36);
        ITEM_STRENGTH_MAP.put(class_1802.field_8848, 0.48);
        ITEM_STRENGTH_MAP.put(class_1802.field_8211, 0.48);
        ITEM_STRENGTH_MAP.put(class_1802.field_8655, 0.48);
        ITEM_STRENGTH_MAP.put(class_1802.field_8251, 0.3);
        ITEM_STRENGTH_MAP.put(class_1802.field_8249, 0.9);
        ITEM_STRENGTH_MAP.put(class_1802.field_8105, 0.9);
        ITEM_STRENGTH_MAP.put(class_1802.field_8366, 0.24);
        ITEM_STRENGTH_MAP.put(class_1802.field_8388, 1.68);
        ITEM_STRENGTH_MAP.put(class_1802.field_8063, 1.8);
        ITEM_STRENGTH_MAP.put(class_1802.field_8069, 1.68);
        ITEM_STRENGTH_MAP.put(class_1802.field_8836, 1.8);
        ITEM_STRENGTH_MAP.put(class_1802.field_16308, 0.9);
        ITEM_STRENGTH_MAP.put(class_1802.field_40864, 0.42);
        ITEM_STRENGTH_MAP.put(class_1802.field_8592, 1.08);
        ITEM_STRENGTH_MAP.put(class_1802.field_8187, 0.72);
        ITEM_STRENGTH_MAP.put(class_1802.field_8705, 0.6);
        ITEM_STRENGTH_MAP.put(class_1802.field_8103, 0.6);
        ITEM_STRENGTH_MAP.put(class_1802.field_27876, 0.6);
        ITEM_STRENGTH_MAP.put(class_1802.field_28354, 0.6);
        ITEM_STRENGTH_MAP.put(class_1802.field_8666, 0.6);
        ITEM_STRENGTH_MAP.put(class_1802.field_8714, 0.6);
        ITEM_STRENGTH_MAP.put(class_1802.field_8478, 0.6);
        ITEM_STRENGTH_MAP.put(class_1802.field_8108, 0.6);
        ITEM_STRENGTH_MAP.put(class_1802.field_37533, 0.6);
        ITEM_STRENGTH_MAP.put(class_1802.field_16539, 0.36);
        ITEM_STRENGTH_MAP.put(class_1802.field_22016, 0.36);
        ITEM_STRENGTH_MAP.put(class_1802.field_8255, 0.3);
        ITEM_STRENGTH_MAP.put(class_1802.field_8175, 0.18);
        ITEM_STRENGTH_MAP.put(class_1802.field_23256, 2.4);
        ITEM_STRENGTH_MAP.put(class_1802.field_8283, 0.72);
        ITEM_STRENGTH_MAP.put(class_1802.field_8873, 1.08);
        ITEM_STRENGTH_MAP.put(class_1802.field_8218, 0.9);
        ITEM_STRENGTH_MAP.put(class_1802.field_8313, 0.72);
        ITEM_STRENGTH_MAP.put(class_1802.field_8725, 0.03);
        ITEM_STRENGTH_MAP.put(class_1802.field_8793, 0.06);
        ITEM_STRENGTH_MAP.put(class_1802.field_8619, 0.12);
        ITEM_STRENGTH_MAP.put(class_1802.field_8857, 0.12);
        ITEM_STRENGTH_MAP.put(class_1802.field_8537, 0.6);
        ITEM_STRENGTH_MAP.put(class_1802.field_8634, 1.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_8449, 1.0);
        ITEM_STRENGTH_MAP.put(class_1802.field_16306, 0.9);
        ITEM_STRENGTH_MAP.put(class_1802.field_8357, 0.48);
        ITEM_STRENGTH_MAP.put(class_1802.field_8878, 0.48);
        ITEM_STRENGTH_MAP.put(class_1802.field_8557, 0.12);
    }

    static {
        MagnetBlockEntity.initializeItemStrengthMap();
    }
}

