/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.abm;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.whyvo.abm.command.RuleCommand;
import com.whyvo.abm.rule.RuleManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="abm")
public class AttributeBaseModifier {
    public static final String MOD_ID = "abm";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final RuleManager RULE_MANAGER = new RuleManager();

    public AttributeBaseModifier(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::onAddReloadListeners);
        MinecraftForge.EVENT_BUS.addListener(this::onRegisterCommands);
    }

    public AttributeBaseModifier(IEventBus modEventBus) {
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::onAddReloadListeners);
        MinecraftForge.EVENT_BUS.addListener(this::onRegisterCommands);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("AttributeBaseModifier initialized!");
    }

    private void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ResourceManagerReloadListener(){
            private static final String NAME = "abm:reload";

            public void m_6213_(ResourceManager manager) {
                RULE_MANAGER.load(manager);
            }

            public String m_7812_() {
                return NAME;
            }
        });
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        RuleCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

