/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.abm.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.whyvo.abm.AttributeBaseModifier;
import com.whyvo.abm.rule.ModifyRule;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class RuleCommand {
    private static final DynamicCommandExceptionType NOTHING_CHANGE_EXCEPTION = new DynamicCommandExceptionType(s -> Component.m_237113_((String)("Nothing change. The rule is already " + s)));
    private static final DynamicCommandExceptionType NOT_FOUND_EXCEPTION = new DynamicCommandExceptionType(id -> Component.m_237113_((String)("Rule not found: " + id)));
    private static final Function<Enable, Component> SUCCESS_MESSAGE = e -> Component.m_237113_((String)("The rule is now " + e));
    public static final SuggestionProvider<CommandSourceStack> SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.m_82926_(AttributeBaseModifier.RULE_MANAGER.getAllRules(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"abmrule").requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGESTION_PROVIDER).then(Commands.m_82127_((String)"enable").executes(context -> RuleCommand.execute((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"name"), Enable.ENABLE)))).then(Commands.m_82127_((String)"disable").executes(context -> RuleCommand.execute((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"name"), Enable.DISABLE)))));
    }

    private static int execute(CommandSourceStack context, ResourceLocation name, Enable enable) throws CommandSyntaxException {
        ModifyRule rule = AttributeBaseModifier.RULE_MANAGER.get(name);
        if (rule == null) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        if (rule.enable == enable.value) {
            throw NOTHING_CHANGE_EXCEPTION.create((Object)enable);
        }
        rule.enable = enable.value;
        context.m_243053_(SUCCESS_MESSAGE.apply(enable));
        return 1;
    }

    private static enum Enable {
        ENABLE(true, "enable"),
        DISABLE(false, "disable");

        public final boolean value;
        public final String name;

        private Enable(boolean value, String name) {
            this.value = value;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

