/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.abm.rule;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.whyvo.abm.rule.Modifiers;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class AttributeModify {
    private final Holder<Attribute> attribute;
    private final Modifiers modifiers;

    private AttributeModify(Holder<Attribute> attribute, Modifiers modifiers) {
        this.attribute = attribute;
        this.modifiers = modifiers;
    }

    public void modify(AttributeMap attributes) {
        AttributeInstance instance = attributes.m_246600_(this.attribute);
        if (instance != null) {
            double baseValue = instance.m_22115_();
            instance.m_22100_(this.modifiers.modify(baseValue));
        }
    }

    @Nullable
    private static Holder<Attribute> getAttributeEntry(ResourceLocation id) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.ATTRIBUTES.getRegistryKey(), (ResourceLocation)id);
        return ForgeRegistries.ATTRIBUTES.getHolder(key).orElse(null);
    }

    public static AttributeModify parse(JsonObject json) {
        String id = json.get("attribute").getAsString();
        Holder<Attribute> attribute = AttributeModify.getAttributeEntry(ResourceLocation.m_135820_((String)id));
        if (attribute == null) {
            throw new JsonParseException("Unknown attribute " + id);
        }
        Modifiers modifiers = Modifiers.parse(json.getAsJsonArray("modifiers"));
        return new AttributeModify(attribute, modifiers);
    }
}

