/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.abm.rule;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.registries.ForgeRegistries;

public class Filter {
    private final List<EntityType<?>> entityTypes;
    private final List<TagKey<EntityType<?>>> tags;
    private final MobCategory spawnGroup;

    private Filter(List<EntityType<?>> entityType, List<TagKey<EntityType<?>>> tags, MobCategory spawnGroup) {
        this.entityTypes = entityType;
        this.tags = tags;
        this.spawnGroup = spawnGroup;
    }

    public boolean test(EntityType<?> entityType) {
        if (this.spawnGroup == null) {
            return this.entityTypes.contains(entityType) || this.testTags(entityType);
        }
        return entityType.m_20674_() == this.spawnGroup;
    }

    private boolean testTags(EntityType<?> entityType) {
        for (TagKey<EntityType<?>> tag : this.tags) {
            if (!entityType.m_204039_(tag)) continue;
            return true;
        }
        return false;
    }

    public static Filter parse(JsonObject json) {
        if (json.has("type")) {
            JsonArray array;
            ArrayList entityTypes = new ArrayList();
            ArrayList tags = new ArrayList();
            JsonElement type = json.get("type");
            if (type instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)type;
                if (!primitive.isString()) {
                    throw new JsonParseException("Expected a string");
                }
                array = new JsonArray();
                array.add(primitive.getAsString());
            } else if (type instanceof JsonArray) {
                array = (JsonArray)type;
            } else {
                throw new JsonParseException("Expected an array or a string");
            }
            for (JsonElement element : array) {
                JsonPrimitive primitive;
                if (element instanceof JsonPrimitive && (primitive = (JsonPrimitive)element).isString()) {
                    ResourceLocation id;
                    String s = primitive.getAsString();
                    if (s.startsWith("#")) {
                        id = ResourceLocation.m_135820_((String)s.substring(1));
                        tags.add(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)id));
                        continue;
                    }
                    id = ResourceLocation.m_135820_((String)s);
                    entityTypes.add((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(id));
                    continue;
                }
                throw new JsonParseException("Expected a string");
            }
            return new Filter(entityTypes, tags, null);
        }
        if (json.has("spawn_group")) {
            return new Filter(null, null, Filter.tryParseSpawnGroup(json.get("spawn_group").getAsString()));
        }
        throw new JsonParseException("Expected type or group");
    }

    private static MobCategory tryParseSpawnGroup(String s) {
        for (MobCategory spawnGroup : MobCategory.values()) {
            if (!spawnGroup.m_21607_().equals(s)) continue;
            return spawnGroup;
        }
        throw new IllegalArgumentException("Invalid spawn group: " + s);
    }
}

