/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.abm.rule;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;

public class Modifiers {
    private final List<Modifier> modifiers;

    private Modifiers(List<Modifier> modifiers) {
        this.modifiers = modifiers;
    }

    public double modify(double base) {
        for (Modifier modifier : this.modifiers) {
            base = modifier.modify(base);
        }
        return base;
    }

    public static Modifiers parse(JsonArray array) {
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
        for (JsonElement element : array) {
            JsonObject obj = element.getAsJsonObject();
            modifiers.add(Modifiers.parseModifier(obj));
        }
        return new Modifiers(modifiers);
    }

    private static Modifier parseModifier(JsonObject json) {
        double value = json.get("value").getAsDouble();
        String type = json.get("type").getAsString();
        if ("set".equals(type)) {
            return Modifiers.createSet(value);
        }
        if ("add".equals(type)) {
            return Modifiers.createAdd(value);
        }
        if ("multiply".equals(type)) {
            return Modifiers.createMultiply(value);
        }
        throw new JsonParseException("Unknown modifier type: " + type);
    }

    private static Modifier createSet(double value) {
        return new Modifier((base, value1) -> value1, value);
    }

    private static Modifier createAdd(double value) {
        return new Modifier(Double::sum, value);
    }

    private static Modifier createMultiply(double value) {
        return new Modifier((base, value1) -> base * value1, value);
    }

    private record Modifier(Operation operation, double value) {
        public double modify(double base) {
            return this.operation.modify(base, this.value);
        }
    }

    private static interface Operation {
        public double modify(double var1, double var3);
    }
}

