/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.abm.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.whyvo.abm.AttributeBaseModifier;
import com.whyvo.abm.rule.ModifyRule;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class RuleCommand {
    private static final DynamicCommandExceptionType NOTHING_CHANGE_EXCEPTION = new DynamicCommandExceptionType(s -> Component.literal((String)("Nothing change. The rule is already " + String.valueOf(s))));
    private static final DynamicCommandExceptionType NOT_FOUND_EXCEPTION = new DynamicCommandExceptionType(id -> Component.literal((String)("Rule not found: " + String.valueOf(id))));
    private static final Function<Enable, Component> SUCCESS_MESSAGE = e -> Component.literal((String)("The rule is now " + String.valueOf(e)));
    public static final SuggestionProvider<CommandSourceStack> SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggestResource(AttributeBaseModifier.RULE_MANAGER.getAllRules(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"abmrule").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGESTION_PROVIDER).then(Commands.literal((String)"enable").executes(context -> RuleCommand.execute((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext)context, (String)"name"), Enable.ENABLE)))).then(Commands.literal((String)"disable").executes(context -> RuleCommand.execute((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext)context, (String)"name"), Enable.DISABLE)))));
    }

    private static int execute(CommandSourceStack context, ResourceLocation name, Enable enable) throws CommandSyntaxException {
        ModifyRule rule = AttributeBaseModifier.RULE_MANAGER.get(name);
        if (rule == null) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        if (rule.enable == enable.value) {
            throw NOTHING_CHANGE_EXCEPTION.create((Object)enable);
        }
        rule.enable = enable.value;
        context.sendSystemMessage(SUCCESS_MESSAGE.apply(enable));
        return 1;
    }

    private static enum Enable {
        ENABLE(true, "enable"),
        DISABLE(false, "disable");

        public final boolean value;
        public final String name;

        private Enable(boolean value, String name) {
            this.value = value;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

