/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.abm.rule;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.whyvo.abm.rule.AttributeModify;
import com.whyvo.abm.rule.Filter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeMap;

public class ModifyRule {
    private final Filter includeFilter;
    private final Filter excludeFilter;
    private final List<AttributeModify> modifies;
    public boolean enable;

    private ModifyRule(Filter includeFilter, Filter excludeFilter, List<AttributeModify> modifies) {
        this(includeFilter, excludeFilter, modifies, true);
    }

    private ModifyRule(Filter includeFilter, Filter excludeFilter, List<AttributeModify> modifies, boolean enable) {
        this.includeFilter = includeFilter;
        this.excludeFilter = excludeFilter;
        this.modifies = modifies;
        this.enable = enable;
    }

    public boolean test(EntityType<?> entityType) {
        return !(this.includeFilter != null && !this.includeFilter.test(entityType) || this.excludeFilter != null && this.excludeFilter.test(entityType));
    }

    public void modify(AttributeMap attributes) {
        for (AttributeModify modify : this.modifies) {
            modify.modify(attributes);
        }
    }

    public static ModifyRule parse(JsonObject json) {
        JsonObject jsonObject;
        Filter includeFilter = null;
        Filter excludeFilter = null;
        if (json.has("include")) {
            jsonObject = json.getAsJsonObject("include");
            includeFilter = Filter.parse(jsonObject);
        }
        if (json.has("exclude")) {
            jsonObject = json.getAsJsonObject("exclude");
            excludeFilter = Filter.parse(jsonObject);
        }
        ArrayList<AttributeModify> modifies = new ArrayList<AttributeModify>();
        JsonArray jsonArray = json.getAsJsonArray("modifies");
        for (JsonElement jsonElement : jsonArray) {
            JsonObject o = jsonElement.getAsJsonObject();
            modifies.add(AttributeModify.parse(o));
        }
        if (json.has("default_enable")) {
            return new ModifyRule(includeFilter, excludeFilter, modifies, json.get("default_enable").getAsBoolean());
        }
        return new ModifyRule(includeFilter, excludeFilter, modifies);
    }
}

