/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.abm.rule;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.whyvo.abm.AttributeBaseModifier;
import com.whyvo.abm.rule.ModifyRule;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import org.jetbrains.annotations.Nullable;

public class RuleManager {
    private static final FileToIdConverter FINDER = FileToIdConverter.json((String)"abm_rules");
    private final Map<ResourceLocation, ModifyRule> rulesMap = new HashMap<ResourceLocation, ModifyRule>();
    private final List<ModifyRule> rules = new ArrayList<ModifyRule>();

    public void applyRules(EntityType<? extends LivingEntity> entityType, AttributeMap attributes) {
        for (ModifyRule rule : this.rules) {
            if (!rule.enable || !rule.test(entityType)) continue;
            rule.modify(attributes);
        }
    }

    @Nullable
    public ModifyRule get(ResourceLocation id) {
        return this.rulesMap.get(id);
    }

    public Iterable<ResourceLocation> getAllRules() {
        return this.rulesMap.keySet();
    }

    public void load(ResourceManager resourceManager) {
        this.rulesMap.clear();
        this.rules.clear();
        Map resources = FINDER.listMatchingResources(resourceManager);
        for (Map.Entry entry : resources.entrySet()) {
            ResourceLocation id = FINDER.fileToId((ResourceLocation)entry.getKey());
            try {
                JsonObject json = JsonParser.parseReader((Reader)((Resource)entry.getValue()).openAsReader()).getAsJsonObject();
                ModifyRule rule = ModifyRule.parse(json);
                this.rulesMap.put(id, rule);
                this.rules.add(rule);
            }
            catch (Exception e) {
                AttributeBaseModifier.LOGGER.warn("Failed to parse rule {}, ignored", (Object)id);
                AttributeBaseModifier.LOGGER.debug("Failed loading rule: ", (Throwable)e);
            }
        }
        AttributeBaseModifier.LOGGER.info("Loaded {} rules", (Object)this.rules.size());
    }
}

