/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kimetsunoyaiba.network;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.mcreator.kimetsunoyaiba.KimetsunoyaibaMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class KimetsunoyaibaModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        KimetsunoyaibaMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        KimetsunoyaibaMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        KimetsunoyaibaMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final int target;
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
            this.target = buffer.readInt();
        }

        public PlayerVariablesSyncMessage(PlayerVariables data, int entityid) {
            this.data = data;
            this.target = entityid;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
            buffer.writeInt(message.target);
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.target).getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.player_receiveDamage = message.data.player_receiveDamage;
                    variables.player_usedBreathingNum = message.data.player_usedBreathingNum;
                    variables.player_nichirincolor = message.data.player_nichirincolor;
                    variables.mode = message.data.mode;
                    variables.KILL_POINT_1 = message.data.KILL_POINT_1;
                    variables.KILL_POINT_2 = message.data.KILL_POINT_2;
                    variables.kill_hashira = message.data.kill_hashira;
                    variables.PlayerLevel = message.data.PlayerLevel;
                    variables.playerBack = message.data.playerBack;
                    variables.NUM_SKILL = message.data.NUM_SKILL;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double player_receiveDamage = 0.0;
        public double player_usedBreathingNum = 0.0;
        public double player_nichirincolor = 0.0;
        public double mode = 0.0;
        public double KILL_POINT_1 = 0.0;
        public double KILL_POINT_2 = 0.0;
        public boolean kill_hashira = false;
        public double PlayerLevel = 0.0;
        public boolean playerBack = false;
        public double NUM_SKILL = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                KimetsunoyaibaMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)entity.m_9236_()).m_46472_()), (Object)new PlayerVariablesSyncMessage(this, entity.m_19879_()));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("player_receiveDamage", this.player_receiveDamage);
            nbt.m_128347_("player_usedBreathingNum", this.player_usedBreathingNum);
            nbt.m_128347_("player_nichirincolor", this.player_nichirincolor);
            nbt.m_128347_("mode", this.mode);
            nbt.m_128347_("KILL_POINT_1", this.KILL_POINT_1);
            nbt.m_128347_("KILL_POINT_2", this.KILL_POINT_2);
            nbt.m_128379_("kill_hashira", this.kill_hashira);
            nbt.m_128347_("PlayerLevel", this.PlayerLevel);
            nbt.m_128379_("playerBack", this.playerBack);
            nbt.m_128347_("NUM_SKILL", this.NUM_SKILL);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt;
            if (tag == null) {
                tag = this.writeNBT();
            }
            if ((nbt = (CompoundTag)tag) == null) {
                nbt = (CompoundTag)this.writeNBT();
            }
            this.player_receiveDamage = nbt.m_128459_("player_receiveDamage");
            this.player_usedBreathingNum = nbt.m_128459_("player_usedBreathingNum");
            this.player_nichirincolor = nbt.m_128459_("player_nichirincolor");
            this.mode = nbt.m_128459_("mode");
            this.KILL_POINT_1 = nbt.m_128459_("KILL_POINT_1");
            this.KILL_POINT_2 = nbt.m_128459_("KILL_POINT_2");
            this.kill_hashira = nbt.m_128471_("kill_hashira");
            this.PlayerLevel = nbt.m_128459_("PlayerLevel");
            this.playerBack = nbt.m_128471_("playerBack");
            this.NUM_SKILL = nbt.m_128459_("NUM_SKILL");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("kimetsunoyaiba", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "kimetsunoyaiba_mapvars";
        public double kamoboko_level = 0.0;
        public boolean flag_zenitsu = false;
        public boolean flag_wakuraba = false;
        public boolean flag_uzui = false;
        public boolean flag_tomioka = false;
        public boolean flag_tokito = false;
        public boolean flag_tanjiro = false;
        public boolean flag_spawn_tanjiro_demon = false;
        public boolean flag_shinazugawa = false;
        public boolean flag_saikoro = false;
        public boolean flag_rui = false;
        public boolean flag_rokuro = false;
        public boolean flag_rengoku = false;
        public boolean flag_nezuko = false;
        public boolean flag_muzan = false;
        public boolean flag_mukago = false;
        public boolean flag_kokushibo = false;
        public boolean flag_kocho_shinobu = false;
        public boolean flag_kanroji = false;
        public boolean flag_kanawo = false;
        public boolean flag_kanae = false;
        public boolean flag_kamanue = false;
        public boolean flag_kaigaku = false;
        public boolean flag_inosuke = false;
        public boolean flag_iguro = false;
        public boolean flag_himejima = false;
        public boolean flag_hantengu = false;
        public boolean flag_gyutaro = false;
        public boolean flag_gyokko = false;
        public boolean flag_genya = false;
        public boolean flag_gamestart = false;
        public boolean flag_enmu = false;
        public boolean flag_doma = false;
        public boolean flag_akaza = false;
        public boolean flag_hairo = false;
        public boolean flag_demonKing = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            if (nbt == null) {
                nbt = this.m_7176_(new CompoundTag());
            }
            this.kamoboko_level = nbt.m_128459_("kamoboko_level");
            this.flag_zenitsu = nbt.m_128471_("flag_zenitsu");
            this.flag_wakuraba = nbt.m_128471_("flag_wakuraba");
            this.flag_uzui = nbt.m_128471_("flag_uzui");
            this.flag_tomioka = nbt.m_128471_("flag_tomioka");
            this.flag_tokito = nbt.m_128471_("flag_tokito");
            this.flag_tanjiro = nbt.m_128471_("flag_tanjiro");
            this.flag_spawn_tanjiro_demon = nbt.m_128471_("flag_spawn_tanjiro_demon");
            this.flag_shinazugawa = nbt.m_128471_("flag_shinazugawa");
            this.flag_saikoro = nbt.m_128471_("flag_saikoro");
            this.flag_rui = nbt.m_128471_("flag_rui");
            this.flag_rokuro = nbt.m_128471_("flag_rokuro");
            this.flag_rengoku = nbt.m_128471_("flag_rengoku");
            this.flag_nezuko = nbt.m_128471_("flag_nezuko");
            this.flag_muzan = nbt.m_128471_("flag_muzan");
            this.flag_mukago = nbt.m_128471_("flag_mukago");
            this.flag_kokushibo = nbt.m_128471_("flag_kokushibo");
            this.flag_kocho_shinobu = nbt.m_128471_("flag_kocho_shinobu");
            this.flag_kanroji = nbt.m_128471_("flag_kanroji");
            this.flag_kanawo = nbt.m_128471_("flag_kanawo");
            this.flag_kanae = nbt.m_128471_("flag_kanae");
            this.flag_kamanue = nbt.m_128471_("flag_kamanue");
            this.flag_kaigaku = nbt.m_128471_("flag_kaigaku");
            this.flag_inosuke = nbt.m_128471_("flag_inosuke");
            this.flag_iguro = nbt.m_128471_("flag_iguro");
            this.flag_himejima = nbt.m_128471_("flag_himejima");
            this.flag_hantengu = nbt.m_128471_("flag_hantengu");
            this.flag_gyutaro = nbt.m_128471_("flag_gyutaro");
            this.flag_gyokko = nbt.m_128471_("flag_gyokko");
            this.flag_genya = nbt.m_128471_("flag_genya");
            this.flag_gamestart = nbt.m_128471_("flag_gamestart");
            this.flag_enmu = nbt.m_128471_("flag_enmu");
            this.flag_doma = nbt.m_128471_("flag_doma");
            this.flag_akaza = nbt.m_128471_("flag_akaza");
            this.flag_hairo = nbt.m_128471_("flag_hairo");
            this.flag_demonKing = nbt.m_128471_("flag_demonKing");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("kamoboko_level", this.kamoboko_level);
            nbt.m_128379_("flag_zenitsu", this.flag_zenitsu);
            nbt.m_128379_("flag_wakuraba", this.flag_wakuraba);
            nbt.m_128379_("flag_uzui", this.flag_uzui);
            nbt.m_128379_("flag_tomioka", this.flag_tomioka);
            nbt.m_128379_("flag_tokito", this.flag_tokito);
            nbt.m_128379_("flag_tanjiro", this.flag_tanjiro);
            nbt.m_128379_("flag_spawn_tanjiro_demon", this.flag_spawn_tanjiro_demon);
            nbt.m_128379_("flag_shinazugawa", this.flag_shinazugawa);
            nbt.m_128379_("flag_saikoro", this.flag_saikoro);
            nbt.m_128379_("flag_rui", this.flag_rui);
            nbt.m_128379_("flag_rokuro", this.flag_rokuro);
            nbt.m_128379_("flag_rengoku", this.flag_rengoku);
            nbt.m_128379_("flag_nezuko", this.flag_nezuko);
            nbt.m_128379_("flag_muzan", this.flag_muzan);
            nbt.m_128379_("flag_mukago", this.flag_mukago);
            nbt.m_128379_("flag_kokushibo", this.flag_kokushibo);
            nbt.m_128379_("flag_kocho_shinobu", this.flag_kocho_shinobu);
            nbt.m_128379_("flag_kanroji", this.flag_kanroji);
            nbt.m_128379_("flag_kanawo", this.flag_kanawo);
            nbt.m_128379_("flag_kanae", this.flag_kanae);
            nbt.m_128379_("flag_kamanue", this.flag_kamanue);
            nbt.m_128379_("flag_kaigaku", this.flag_kaigaku);
            nbt.m_128379_("flag_inosuke", this.flag_inosuke);
            nbt.m_128379_("flag_iguro", this.flag_iguro);
            nbt.m_128379_("flag_himejima", this.flag_himejima);
            nbt.m_128379_("flag_hantengu", this.flag_hantengu);
            nbt.m_128379_("flag_gyutaro", this.flag_gyutaro);
            nbt.m_128379_("flag_gyokko", this.flag_gyokko);
            nbt.m_128379_("flag_genya", this.flag_genya);
            nbt.m_128379_("flag_gamestart", this.flag_gamestart);
            nbt.m_128379_("flag_enmu", this.flag_enmu);
            nbt.m_128379_("flag_doma", this.flag_doma);
            nbt.m_128379_("flag_akaza", this.flag_akaza);
            nbt.m_128379_("flag_hairo", this.flag_hairo);
            nbt.m_128379_("flag_demonKing", this.flag_demonKing);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                KimetsunoyaibaMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "kimetsunoyaiba_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                KimetsunoyaibaMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.player_receiveDamage = original.player_receiveDamage;
            clone.player_usedBreathingNum = original.player_usedBreathingNum;
            clone.mode = original.mode;
            clone.KILL_POINT_1 = original.KILL_POINT_1;
            clone.KILL_POINT_2 = original.KILL_POINT_2;
            clone.kill_hashira = original.kill_hashira;
            clone.PlayerLevel = original.PlayerLevel;
            if (!event.isWasDeath()) {
                clone.player_nichirincolor = original.player_nichirincolor;
                clone.playerBack = original.playerBack;
                clone.NUM_SKILL = original.NUM_SKILL;
            }
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    KimetsunoyaibaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    KimetsunoyaibaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                KimetsunoyaibaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

